<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPresaleHistory-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPresaleHistory-Request
 * @subpackage Structs
 */
class GetPresaleHistory_Request extends ExtensibleDataContract
{
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * Constructor method for GetPresaleHistory-Request
     * @uses GetPresaleHistory_Request::setPresaleId()
     * @param string $presaleId
     */
    public function __construct($presaleId = null)
    {
        $this
            ->setPresaleId($presaleId);
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\GetPresaleHistory_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
}
