<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMerchandiseDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMerchandiseDescription-Request
 * @subpackage Structs
 */
class GetMerchandiseDescription_Request extends ExtensibleDataContract
{
    /**
     * The IncludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePricing;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * Constructor method for GetMerchandiseDescription-Request
     * @uses GetMerchandiseDescription_Request::setIncludePricing()
     * @uses GetMerchandiseDescription_Request::setMerchandiseId()
     * @param bool $includePricing
     * @param string $merchandiseId
     */
    public function __construct($includePricing = null, $merchandiseId = null)
    {
        $this
            ->setIncludePricing($includePricing)
            ->setMerchandiseId($merchandiseId);
    }
    /**
     * Get IncludePricing value
     * @return bool|null
     */
    public function getIncludePricing()
    {
        return $this->IncludePricing;
    }
    /**
     * Set IncludePricing value
     * @param bool $includePricing
     * @return \patest\StructType\GetMerchandiseDescription_Request
     */
    public function setIncludePricing($includePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePricing) && !is_bool($includePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePricing, true), gettype($includePricing)), __LINE__);
        }
        $this->IncludePricing = $includePricing;
        return $this;
    }
    /**
     * Get MerchandiseId value
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return $this->MerchandiseId;
    }
    /**
     * Set MerchandiseId value
     * @param string $merchandiseId
     * @return \patest\StructType\GetMerchandiseDescription_Request
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        $this->MerchandiseId = $merchandiseId;
        return $this;
    }
}
