<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLinkedClientsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetLinkedClientsResponse
 * @subpackage Structs
 */
class GetLinkedClientsResponse extends AbstractStructBase
{
    /**
     * The HasMoreResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasMoreResults;
    /**
     * The LinkedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfLinkedClient
     */
    public $LinkedClients;
    /**
     * Constructor method for GetLinkedClientsResponse
     * @uses GetLinkedClientsResponse::setHasMoreResults()
     * @uses GetLinkedClientsResponse::setLinkedClients()
     * @param bool $hasMoreResults
     * @param \patest\ArrayType\ArrayOfLinkedClient $linkedClients
     */
    public function __construct($hasMoreResults = null, \patest\ArrayType\ArrayOfLinkedClient $linkedClients = null)
    {
        $this
            ->setHasMoreResults($hasMoreResults)
            ->setLinkedClients($linkedClients);
    }
    /**
     * Get HasMoreResults value
     * @return bool|null
     */
    public function getHasMoreResults()
    {
        return $this->HasMoreResults;
    }
    /**
     * Set HasMoreResults value
     * @param bool $hasMoreResults
     * @return \patest\StructType\GetLinkedClientsResponse
     */
    public function setHasMoreResults($hasMoreResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreResults) && !is_bool($hasMoreResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMoreResults, true), gettype($hasMoreResults)), __LINE__);
        }
        $this->HasMoreResults = $hasMoreResults;
        return $this;
    }
    /**
     * Get LinkedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfLinkedClient|null
     */
    public function getLinkedClients()
    {
        return isset($this->LinkedClients) ? $this->LinkedClients : null;
    }
    /**
     * Set LinkedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfLinkedClient $linkedClients
     * @return \patest\StructType\GetLinkedClientsResponse
     */
    public function setLinkedClients(\patest\ArrayType\ArrayOfLinkedClient $linkedClients = null)
    {
        if (is_null($linkedClients) || (is_array($linkedClients) && empty($linkedClients))) {
            unset($this->LinkedClients);
        } else {
            $this->LinkedClients = $linkedClients;
        }
        return $this;
    }
}
