<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventUpgradeConfig-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventUpgradeConfig-Response
 * @subpackage Structs
 */
class GetEventUpgradeConfig_Response extends ExtensibleDataContract
{
    /**
     * The AvailableForUpgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForUpgrade;
    /**
     * The BlockedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $BlockedPriceTypes;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * Constructor method for GetEventUpgradeConfig-Response
     * @uses GetEventUpgradeConfig_Response::setAvailableForUpgrade()
     * @uses GetEventUpgradeConfig_Response::setBlockedPriceTypes()
     * @uses GetEventUpgradeConfig_Response::setEventId()
     * @param bool $availableForUpgrade
     * @param \patest\ArrayType\ArrayOfguid $blockedPriceTypes
     * @param string $eventId
     */
    public function __construct($availableForUpgrade = null, \patest\ArrayType\ArrayOfguid $blockedPriceTypes = null, $eventId = null)
    {
        $this
            ->setAvailableForUpgrade($availableForUpgrade)
            ->setBlockedPriceTypes($blockedPriceTypes)
            ->setEventId($eventId);
    }
    /**
     * Get AvailableForUpgrade value
     * @return bool|null
     */
    public function getAvailableForUpgrade()
    {
        return $this->AvailableForUpgrade;
    }
    /**
     * Set AvailableForUpgrade value
     * @param bool $availableForUpgrade
     * @return \patest\StructType\GetEventUpgradeConfig_Response
     */
    public function setAvailableForUpgrade($availableForUpgrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForUpgrade) && !is_bool($availableForUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForUpgrade, true), gettype($availableForUpgrade)), __LINE__);
        }
        $this->AvailableForUpgrade = $availableForUpgrade;
        return $this;
    }
    /**
     * Get BlockedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getBlockedPriceTypes()
    {
        return isset($this->BlockedPriceTypes) ? $this->BlockedPriceTypes : null;
    }
    /**
     * Set BlockedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $blockedPriceTypes
     * @return \patest\StructType\GetEventUpgradeConfig_Response
     */
    public function setBlockedPriceTypes(\patest\ArrayType\ArrayOfguid $blockedPriceTypes = null)
    {
        if (is_null($blockedPriceTypes) || (is_array($blockedPriceTypes) && empty($blockedPriceTypes))) {
            unset($this->BlockedPriceTypes);
        } else {
            $this->BlockedPriceTypes = $blockedPriceTypes;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetEventUpgradeConfig_Response
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
}
