<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventTickets-Request
 * @subpackage Structs
 */
class GetEventTickets_Request extends ExtensibleDataContract
{
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ClientIds;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The QueryOnBehalfOfClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryOnBehalfOfClientId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The UsePurchasers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsePurchasers;
    /**
     * Constructor method for GetEventTickets-Request
     * @uses GetEventTickets_Request::setClientIds()
     * @uses GetEventTickets_Request::setEventIds()
     * @uses GetEventTickets_Request::setQueryOnBehalfOfClientId()
     * @uses GetEventTickets_Request::setStartDate()
     * @uses GetEventTickets_Request::setUsePurchasers()
     * @param \patest\ArrayType\ArrayOfguid $clientIds
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param string $queryOnBehalfOfClientId
     * @param string $startDate
     * @param bool $usePurchasers
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $clientIds = null, \patest\ArrayType\ArrayOfguid $eventIds = null, $queryOnBehalfOfClientId = null, $startDate = null, $usePurchasers = null)
    {
        $this
            ->setClientIds($clientIds)
            ->setEventIds($eventIds)
            ->setQueryOnBehalfOfClientId($queryOnBehalfOfClientId)
            ->setStartDate($startDate)
            ->setUsePurchasers($usePurchasers);
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $clientIds
     * @return \patest\StructType\GetEventTickets_Request
     */
    public function setClientIds(\patest\ArrayType\ArrayOfguid $clientIds = null)
    {
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\GetEventTickets_Request
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get QueryOnBehalfOfClientId value
     * @return string|null
     */
    public function getQueryOnBehalfOfClientId()
    {
        return $this->QueryOnBehalfOfClientId;
    }
    /**
     * Set QueryOnBehalfOfClientId value
     * @param string $queryOnBehalfOfClientId
     * @return \patest\StructType\GetEventTickets_Request
     */
    public function setQueryOnBehalfOfClientId($queryOnBehalfOfClientId = null)
    {
        // validation for constraint: string
        if (!is_null($queryOnBehalfOfClientId) && !is_string($queryOnBehalfOfClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryOnBehalfOfClientId, true), gettype($queryOnBehalfOfClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryOnBehalfOfClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryOnBehalfOfClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryOnBehalfOfClientId, true)), __LINE__);
        }
        $this->QueryOnBehalfOfClientId = $queryOnBehalfOfClientId;
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\GetEventTickets_Request
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get UsePurchasers value
     * @return bool|null
     */
    public function getUsePurchasers()
    {
        return $this->UsePurchasers;
    }
    /**
     * Set UsePurchasers value
     * @param bool $usePurchasers
     * @return \patest\StructType\GetEventTickets_Request
     */
    public function setUsePurchasers($usePurchasers = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePurchasers) && !is_bool($usePurchasers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePurchasers, true), gettype($usePurchasers)), __LINE__);
        }
        $this->UsePurchasers = $usePurchasers;
        return $this;
    }
}
