<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventSeatStatus-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventSeatStatus-Request
 * @subpackage Structs
 */
class GetEventSeatStatus_Request extends ExtensibleDataContract
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AreaIds;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The StatusLayers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $StatusLayers;
    /**
     * The ForceUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceUpdate;
    /**
     * The SubscriptionInstanceIdsBeingRenewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SubscriptionInstanceIdsBeingRenewed;
    /**
     * The ContextClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContextClientId;
    /**
     * The ContextTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContextTransactionGuid;
    /**
     * The IsIndexedResultSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIndexedResultSupported;
    /**
     * The RelatedOwnedSubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelatedOwnedSubscriptionInstanceIds;
    /**
     * The BestAvailableSeatsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BestAvailableSeatsCount;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The IncludeSessionInfoIfExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSessionInfoIfExists;
    /**
     * The IsSupportingMarketDrivenResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupportingMarketDrivenResalePolicy;
    /**
     * The RelatedToSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedToSeriesId;
    /**
     * Constructor method for GetEventSeatStatus-Request
     * @uses GetEventSeatStatus_Request::setAreaIds()
     * @uses GetEventSeatStatus_Request::setEventId()
     * @uses GetEventSeatStatus_Request::setStatusLayers()
     * @uses GetEventSeatStatus_Request::setForceUpdate()
     * @uses GetEventSeatStatus_Request::setSubscriptionInstanceIdsBeingRenewed()
     * @uses GetEventSeatStatus_Request::setContextClientId()
     * @uses GetEventSeatStatus_Request::setContextTransactionGuid()
     * @uses GetEventSeatStatus_Request::setIsIndexedResultSupported()
     * @uses GetEventSeatStatus_Request::setRelatedOwnedSubscriptionInstanceIds()
     * @uses GetEventSeatStatus_Request::setBestAvailableSeatsCount()
     * @uses GetEventSeatStatus_Request::setEffectiveAvailabilityFilter()
     * @uses GetEventSeatStatus_Request::setIncludeSessionInfoIfExists()
     * @uses GetEventSeatStatus_Request::setIsSupportingMarketDrivenResalePolicy()
     * @uses GetEventSeatStatus_Request::setRelatedToSeriesId()
     * @param \patest\ArrayType\ArrayOfguid $areaIds
     * @param string $eventId
     * @param string[] $statusLayers
     * @param bool $forceUpdate
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed
     * @param string $contextClientId
     * @param string $contextTransactionGuid
     * @param bool $isIndexedResultSupported
     * @param \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds
     * @param int $bestAvailableSeatsCount
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param bool $includeSessionInfoIfExists
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @param string $relatedToSeriesId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $areaIds = null, $eventId = null, array $statusLayers = array(), $forceUpdate = null, \patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed = null, $contextClientId = null, $contextTransactionGuid = null, $isIndexedResultSupported = null, \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds = null, $bestAvailableSeatsCount = null, \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, $includeSessionInfoIfExists = null, $isSupportingMarketDrivenResalePolicy = null, $relatedToSeriesId = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setEventId($eventId)
            ->setStatusLayers($statusLayers)
            ->setForceUpdate($forceUpdate)
            ->setSubscriptionInstanceIdsBeingRenewed($subscriptionInstanceIdsBeingRenewed)
            ->setContextClientId($contextClientId)
            ->setContextTransactionGuid($contextTransactionGuid)
            ->setIsIndexedResultSupported($isIndexedResultSupported)
            ->setRelatedOwnedSubscriptionInstanceIds($relatedOwnedSubscriptionInstanceIds)
            ->setBestAvailableSeatsCount($bestAvailableSeatsCount)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setIncludeSessionInfoIfExists($includeSessionInfoIfExists)
            ->setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy)
            ->setRelatedToSeriesId($relatedToSeriesId);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $areaIds
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setAreaIds(\patest\ArrayType\ArrayOfguid $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get StatusLayers value
     * @return string[]|null
     */
    public function getStatusLayers()
    {
        return $this->StatusLayers;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusLayers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusLayers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusLayersForArrayConstraintsFromSetStatusLayers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEventSeatStatus_RequestStatusLayersItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatStatusLayers::valueIsValid($getEventSeatStatus_RequestStatusLayersItem)) {
                $invalidValues[] = is_object($getEventSeatStatus_RequestStatusLayersItem) ? get_class($getEventSeatStatus_RequestStatusLayersItem) : sprintf('%s(%s)', gettype($getEventSeatStatus_RequestStatusLayersItem), var_export($getEventSeatStatus_RequestStatusLayersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatStatusLayers', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatStatusLayers::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusLayers value
     * @uses \patest\EnumType\SeatStatusLayers::valueIsValid()
     * @uses \patest\EnumType\SeatStatusLayers::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusLayers
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setStatusLayers(array $statusLayers = array())
    {
        // validation for constraint: list
        if ('' !== ($statusLayersArrayErrorMessage = self::validateStatusLayersForArrayConstraintsFromSetStatusLayers($statusLayers))) {
            throw new \InvalidArgumentException($statusLayersArrayErrorMessage, __LINE__);
        }
        $this->StatusLayers = is_array($statusLayers) ? implode(' ', $statusLayers) : null;
        return $this;
    }
    /**
     * Get ForceUpdate value
     * @return bool|null
     */
    public function getForceUpdate()
    {
        return $this->ForceUpdate;
    }
    /**
     * Set ForceUpdate value
     * @param bool $forceUpdate
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setForceUpdate($forceUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceUpdate) && !is_bool($forceUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceUpdate, true), gettype($forceUpdate)), __LINE__);
        }
        $this->ForceUpdate = $forceUpdate;
        return $this;
    }
    /**
     * Get SubscriptionInstanceIdsBeingRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionInstanceIdsBeingRenewed()
    {
        return isset($this->SubscriptionInstanceIdsBeingRenewed) ? $this->SubscriptionInstanceIdsBeingRenewed : null;
    }
    /**
     * Set SubscriptionInstanceIdsBeingRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setSubscriptionInstanceIdsBeingRenewed(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed = null)
    {
        if (is_null($subscriptionInstanceIdsBeingRenewed) || (is_array($subscriptionInstanceIdsBeingRenewed) && empty($subscriptionInstanceIdsBeingRenewed))) {
            unset($this->SubscriptionInstanceIdsBeingRenewed);
        } else {
            $this->SubscriptionInstanceIdsBeingRenewed = $subscriptionInstanceIdsBeingRenewed;
        }
        return $this;
    }
    /**
     * Get ContextClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextClientId()
    {
        return isset($this->ContextClientId) ? $this->ContextClientId : null;
    }
    /**
     * Set ContextClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextClientId
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setContextClientId($contextClientId = null)
    {
        // validation for constraint: string
        if (!is_null($contextClientId) && !is_string($contextClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextClientId, true), gettype($contextClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contextClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contextClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contextClientId, true)), __LINE__);
        }
        if (is_null($contextClientId) || (is_array($contextClientId) && empty($contextClientId))) {
            unset($this->ContextClientId);
        } else {
            $this->ContextClientId = $contextClientId;
        }
        return $this;
    }
    /**
     * Get ContextTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextTransactionGuid()
    {
        return isset($this->ContextTransactionGuid) ? $this->ContextTransactionGuid : null;
    }
    /**
     * Set ContextTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextTransactionGuid
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setContextTransactionGuid($contextTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($contextTransactionGuid) && !is_string($contextTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextTransactionGuid, true), gettype($contextTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contextTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contextTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contextTransactionGuid, true)), __LINE__);
        }
        if (is_null($contextTransactionGuid) || (is_array($contextTransactionGuid) && empty($contextTransactionGuid))) {
            unset($this->ContextTransactionGuid);
        } else {
            $this->ContextTransactionGuid = $contextTransactionGuid;
        }
        return $this;
    }
    /**
     * Get IsIndexedResultSupported value
     * @return bool|null
     */
    public function getIsIndexedResultSupported()
    {
        return $this->IsIndexedResultSupported;
    }
    /**
     * Set IsIndexedResultSupported value
     * @param bool $isIndexedResultSupported
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setIsIndexedResultSupported($isIndexedResultSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIndexedResultSupported) && !is_bool($isIndexedResultSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIndexedResultSupported, true), gettype($isIndexedResultSupported)), __LINE__);
        }
        $this->IsIndexedResultSupported = $isIndexedResultSupported;
        return $this;
    }
    /**
     * Get RelatedOwnedSubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelatedOwnedSubscriptionInstanceIds()
    {
        return isset($this->RelatedOwnedSubscriptionInstanceIds) ? $this->RelatedOwnedSubscriptionInstanceIds : null;
    }
    /**
     * Set RelatedOwnedSubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setRelatedOwnedSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds = null)
    {
        if (is_null($relatedOwnedSubscriptionInstanceIds) || (is_array($relatedOwnedSubscriptionInstanceIds) && empty($relatedOwnedSubscriptionInstanceIds))) {
            unset($this->RelatedOwnedSubscriptionInstanceIds);
        } else {
            $this->RelatedOwnedSubscriptionInstanceIds = $relatedOwnedSubscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get BestAvailableSeatsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBestAvailableSeatsCount()
    {
        return isset($this->BestAvailableSeatsCount) ? $this->BestAvailableSeatsCount : null;
    }
    /**
     * Set BestAvailableSeatsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bestAvailableSeatsCount
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setBestAvailableSeatsCount($bestAvailableSeatsCount = null)
    {
        // validation for constraint: int
        if (!is_null($bestAvailableSeatsCount) && !(is_int($bestAvailableSeatsCount) || ctype_digit($bestAvailableSeatsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bestAvailableSeatsCount, true), gettype($bestAvailableSeatsCount)), __LINE__);
        }
        if (is_null($bestAvailableSeatsCount) || (is_array($bestAvailableSeatsCount) && empty($bestAvailableSeatsCount))) {
            unset($this->BestAvailableSeatsCount);
        } else {
            $this->BestAvailableSeatsCount = $bestAvailableSeatsCount;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get IncludeSessionInfoIfExists value
     * @return bool|null
     */
    public function getIncludeSessionInfoIfExists()
    {
        return $this->IncludeSessionInfoIfExists;
    }
    /**
     * Set IncludeSessionInfoIfExists value
     * @param bool $includeSessionInfoIfExists
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setIncludeSessionInfoIfExists($includeSessionInfoIfExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSessionInfoIfExists) && !is_bool($includeSessionInfoIfExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSessionInfoIfExists, true), gettype($includeSessionInfoIfExists)), __LINE__);
        }
        $this->IncludeSessionInfoIfExists = $includeSessionInfoIfExists;
        return $this;
    }
    /**
     * Get IsSupportingMarketDrivenResalePolicy value
     * @return bool|null
     */
    public function getIsSupportingMarketDrivenResalePolicy()
    {
        return $this->IsSupportingMarketDrivenResalePolicy;
    }
    /**
     * Set IsSupportingMarketDrivenResalePolicy value
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportingMarketDrivenResalePolicy) && !is_bool($isSupportingMarketDrivenResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportingMarketDrivenResalePolicy, true), gettype($isSupportingMarketDrivenResalePolicy)), __LINE__);
        }
        $this->IsSupportingMarketDrivenResalePolicy = $isSupportingMarketDrivenResalePolicy;
        return $this;
    }
    /**
     * Get RelatedToSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToSeriesId()
    {
        return isset($this->RelatedToSeriesId) ? $this->RelatedToSeriesId : null;
    }
    /**
     * Set RelatedToSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToSeriesId
     * @return \patest\StructType\GetEventSeatStatus_Request
     */
    public function setRelatedToSeriesId($relatedToSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToSeriesId) && !is_string($relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToSeriesId, true), gettype($relatedToSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedToSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedToSeriesId, true)), __LINE__);
        }
        if (is_null($relatedToSeriesId) || (is_array($relatedToSeriesId) && empty($relatedToSeriesId))) {
            unset($this->RelatedToSeriesId);
        } else {
            $this->RelatedToSeriesId = $relatedToSeriesId;
        }
        return $this;
    }
}
