<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventPricing-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventPricing-Request
 * @subpackage Structs
 */
class GetEventPricing_Request extends ExtensibleDataContract
{
    /**
     * The AreaPriceLevelIdsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AreaPriceLevelIdsFilter;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The OwnerSubscriptionSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerSubscriptionSeriesId;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The ExtraOfPromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraOfPromptId;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The IncludePriceOverrides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePriceOverrides;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The IncludeBasketLevelPriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeBasketLevelPriceModifiers;
    /**
     * The OverridePriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OverridePriceTypeIds;
    /**
     * Constructor method for GetEventPricing-Request
     * @uses GetEventPricing_Request::setAreaPriceLevelIdsFilter()
     * @uses GetEventPricing_Request::setEventId()
     * @uses GetEventPricing_Request::setOwnerSubscriptionSeriesId()
     * @uses GetEventPricing_Request::setCouponIdentity()
     * @uses GetEventPricing_Request::setExtraOfPromptId()
     * @uses GetEventPricing_Request::setAreaId()
     * @uses GetEventPricing_Request::setIncludePriceOverrides()
     * @uses GetEventPricing_Request::setPresaleId()
     * @uses GetEventPricing_Request::setIncludeBasketLevelPriceModifiers()
     * @uses GetEventPricing_Request::setOverridePriceTypeIds()
     * @param \patest\ArrayType\ArrayOfguid $areaPriceLevelIdsFilter
     * @param string $eventId
     * @param string $ownerSubscriptionSeriesId
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param string $extraOfPromptId
     * @param string $areaId
     * @param bool $includePriceOverrides
     * @param string $presaleId
     * @param bool $includeBasketLevelPriceModifiers
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $areaPriceLevelIdsFilter = null, $eventId = null, $ownerSubscriptionSeriesId = null, \patest\StructType\CouponIdentity $couponIdentity = null, $extraOfPromptId = null, $areaId = null, $includePriceOverrides = null, $presaleId = null, $includeBasketLevelPriceModifiers = null, \patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        $this
            ->setAreaPriceLevelIdsFilter($areaPriceLevelIdsFilter)
            ->setEventId($eventId)
            ->setOwnerSubscriptionSeriesId($ownerSubscriptionSeriesId)
            ->setCouponIdentity($couponIdentity)
            ->setExtraOfPromptId($extraOfPromptId)
            ->setAreaId($areaId)
            ->setIncludePriceOverrides($includePriceOverrides)
            ->setPresaleId($presaleId)
            ->setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers)
            ->setOverridePriceTypeIds($overridePriceTypeIds);
    }
    /**
     * Get AreaPriceLevelIdsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAreaPriceLevelIdsFilter()
    {
        return isset($this->AreaPriceLevelIdsFilter) ? $this->AreaPriceLevelIdsFilter : null;
    }
    /**
     * Set AreaPriceLevelIdsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $areaPriceLevelIdsFilter
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setAreaPriceLevelIdsFilter(\patest\ArrayType\ArrayOfguid $areaPriceLevelIdsFilter = null)
    {
        if (is_null($areaPriceLevelIdsFilter) || (is_array($areaPriceLevelIdsFilter) && empty($areaPriceLevelIdsFilter))) {
            unset($this->AreaPriceLevelIdsFilter);
        } else {
            $this->AreaPriceLevelIdsFilter = $areaPriceLevelIdsFilter;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get OwnerSubscriptionSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerSubscriptionSeriesId()
    {
        return isset($this->OwnerSubscriptionSeriesId) ? $this->OwnerSubscriptionSeriesId : null;
    }
    /**
     * Set OwnerSubscriptionSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerSubscriptionSeriesId
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setOwnerSubscriptionSeriesId($ownerSubscriptionSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerSubscriptionSeriesId) && !is_string($ownerSubscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerSubscriptionSeriesId, true), gettype($ownerSubscriptionSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerSubscriptionSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerSubscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerSubscriptionSeriesId, true)), __LINE__);
        }
        if (is_null($ownerSubscriptionSeriesId) || (is_array($ownerSubscriptionSeriesId) && empty($ownerSubscriptionSeriesId))) {
            unset($this->OwnerSubscriptionSeriesId);
        } else {
            $this->OwnerSubscriptionSeriesId = $ownerSubscriptionSeriesId;
        }
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get ExtraOfPromptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraOfPromptId()
    {
        return isset($this->ExtraOfPromptId) ? $this->ExtraOfPromptId : null;
    }
    /**
     * Set ExtraOfPromptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraOfPromptId
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setExtraOfPromptId($extraOfPromptId = null)
    {
        // validation for constraint: string
        if (!is_null($extraOfPromptId) && !is_string($extraOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraOfPromptId, true), gettype($extraOfPromptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraOfPromptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraOfPromptId, true)), __LINE__);
        }
        if (is_null($extraOfPromptId) || (is_array($extraOfPromptId) && empty($extraOfPromptId))) {
            unset($this->ExtraOfPromptId);
        } else {
            $this->ExtraOfPromptId = $extraOfPromptId;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get IncludePriceOverrides value
     * @return bool|null
     */
    public function getIncludePriceOverrides()
    {
        return $this->IncludePriceOverrides;
    }
    /**
     * Set IncludePriceOverrides value
     * @param bool $includePriceOverrides
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setIncludePriceOverrides($includePriceOverrides = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePriceOverrides) && !is_bool($includePriceOverrides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePriceOverrides, true), gettype($includePriceOverrides)), __LINE__);
        }
        $this->IncludePriceOverrides = $includePriceOverrides;
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get IncludeBasketLevelPriceModifiers value
     * @return bool|null
     */
    public function getIncludeBasketLevelPriceModifiers()
    {
        return $this->IncludeBasketLevelPriceModifiers;
    }
    /**
     * Set IncludeBasketLevelPriceModifiers value
     * @param bool $includeBasketLevelPriceModifiers
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBasketLevelPriceModifiers) && !is_bool($includeBasketLevelPriceModifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBasketLevelPriceModifiers, true), gettype($includeBasketLevelPriceModifiers)), __LINE__);
        }
        $this->IncludeBasketLevelPriceModifiers = $includeBasketLevelPriceModifiers;
        return $this;
    }
    /**
     * Get OverridePriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOverridePriceTypeIds()
    {
        return isset($this->OverridePriceTypeIds) ? $this->OverridePriceTypeIds : null;
    }
    /**
     * Set OverridePriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     * @return \patest\StructType\GetEventPricing_Request
     */
    public function setOverridePriceTypeIds(\patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        if (is_null($overridePriceTypeIds) || (is_array($overridePriceTypeIds) && empty($overridePriceTypeIds))) {
            unset($this->OverridePriceTypeIds);
        } else {
            $this->OverridePriceTypeIds = $overridePriceTypeIds;
        }
        return $this;
    }
}
