<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventInfoFromSgoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventInfoFromSgoResponse
 * @subpackage Structs
 */
class GetEventInfoFromSgoResponse extends AbstractStructBase
{
    /**
     * The EventsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea
     */
    public $EventsInfo;
    /**
     * The IsSgoServiceAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSgoServiceAvailable;
    /**
     * The SgoServiceErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SgoServiceErrorMessage;
    /**
     * Constructor method for GetEventInfoFromSgoResponse
     * @uses GetEventInfoFromSgoResponse::setEventsInfo()
     * @uses GetEventInfoFromSgoResponse::setIsSgoServiceAvailable()
     * @uses GetEventInfoFromSgoResponse::setSgoServiceErrorMessage()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea $eventsInfo
     * @param bool $isSgoServiceAvailable
     * @param string $sgoServiceErrorMessage
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea $eventsInfo = null, $isSgoServiceAvailable = null, $sgoServiceErrorMessage = null)
    {
        $this
            ->setEventsInfo($eventsInfo)
            ->setIsSgoServiceAvailable($isSgoServiceAvailable)
            ->setSgoServiceErrorMessage($sgoServiceErrorMessage);
    }
    /**
     * Get EventsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea|null
     */
    public function getEventsInfo()
    {
        return isset($this->EventsInfo) ? $this->EventsInfo : null;
    }
    /**
     * Set EventsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea $eventsInfo
     * @return \patest\StructType\GetEventInfoFromSgoResponse
     */
    public function setEventsInfo(\patest\ArrayType\ArrayOfKeyValueOfguidEventStatusInfohpjoQDea $eventsInfo = null)
    {
        if (is_null($eventsInfo) || (is_array($eventsInfo) && empty($eventsInfo))) {
            unset($this->EventsInfo);
        } else {
            $this->EventsInfo = $eventsInfo;
        }
        return $this;
    }
    /**
     * Get IsSgoServiceAvailable value
     * @return bool|null
     */
    public function getIsSgoServiceAvailable()
    {
        return $this->IsSgoServiceAvailable;
    }
    /**
     * Set IsSgoServiceAvailable value
     * @param bool $isSgoServiceAvailable
     * @return \patest\StructType\GetEventInfoFromSgoResponse
     */
    public function setIsSgoServiceAvailable($isSgoServiceAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSgoServiceAvailable) && !is_bool($isSgoServiceAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSgoServiceAvailable, true), gettype($isSgoServiceAvailable)), __LINE__);
        }
        $this->IsSgoServiceAvailable = $isSgoServiceAvailable;
        return $this;
    }
    /**
     * Get SgoServiceErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSgoServiceErrorMessage()
    {
        return isset($this->SgoServiceErrorMessage) ? $this->SgoServiceErrorMessage : null;
    }
    /**
     * Set SgoServiceErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sgoServiceErrorMessage
     * @return \patest\StructType\GetEventInfoFromSgoResponse
     */
    public function setSgoServiceErrorMessage($sgoServiceErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sgoServiceErrorMessage) && !is_string($sgoServiceErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sgoServiceErrorMessage, true), gettype($sgoServiceErrorMessage)), __LINE__);
        }
        if (is_null($sgoServiceErrorMessage) || (is_array($sgoServiceErrorMessage) && empty($sgoServiceErrorMessage))) {
            unset($this->SgoServiceErrorMessage);
        } else {
            $this->SgoServiceErrorMessage = $sgoServiceErrorMessage;
        }
        return $this;
    }
}
