<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventData-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventData-Response
 * @subpackage Structs
 */
class GetEventData_Response extends ExtensibleDataContract
{
    /**
     * The EventData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Event
     */
    public $EventData;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * Constructor method for GetEventData-Response
     * @uses GetEventData_Response::setEventData()
     * @uses GetEventData_Response::setVenueId()
     * @param \patest\StructType\Ticketing_Event $eventData
     * @param string $venueId
     */
    public function __construct(\patest\StructType\Ticketing_Event $eventData = null, $venueId = null)
    {
        $this
            ->setEventData($eventData)
            ->setVenueId($venueId);
    }
    /**
     * Get EventData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Event|null
     */
    public function getEventData()
    {
        return isset($this->EventData) ? $this->EventData : null;
    }
    /**
     * Set EventData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Event $eventData
     * @return \patest\StructType\GetEventData_Response
     */
    public function setEventData(\patest\StructType\Ticketing_Event $eventData = null)
    {
        if (is_null($eventData) || (is_array($eventData) && empty($eventData))) {
            unset($this->EventData);
        } else {
            $this->EventData = $eventData;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\GetEventData_Response
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
}
