<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeletedEntitiesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDeletedEntitiesRequest
 * @subpackage Structs
 */
class GetDeletedEntitiesRequest extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $To;
    /**
     * Constructor method for GetDeletedEntitiesRequest
     * @uses GetDeletedEntitiesRequest::setEntityName()
     * @uses GetDeletedEntitiesRequest::setFrom()
     * @uses GetDeletedEntitiesRequest::setTo()
     * @param string $entityName
     * @param string $from
     * @param string $to
     */
    public function __construct($entityName = null, $from = null, $to = null)
    {
        $this
            ->setEntityName($entityName)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\GetDeletedEntitiesRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \patest\StructType\GetDeletedEntitiesRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \patest\StructType\GetDeletedEntitiesRequest
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
