<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCurrentShiftRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCurrentShiftRequest
 * @subpackage Structs
 */
class GetCurrentShiftRequest extends AbstractStructBase
{
    /**
     * The DoNotOpenNewShift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DoNotOpenNewShift;
    /**
     * The ForceGetData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceGetData;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * Constructor method for GetCurrentShiftRequest
     * @uses GetCurrentShiftRequest::setDoNotOpenNewShift()
     * @uses GetCurrentShiftRequest::setForceGetData()
     * @uses GetCurrentShiftRequest::setTillId()
     * @param bool $doNotOpenNewShift
     * @param bool $forceGetData
     * @param string $tillId
     */
    public function __construct($doNotOpenNewShift = null, $forceGetData = null, $tillId = null)
    {
        $this
            ->setDoNotOpenNewShift($doNotOpenNewShift)
            ->setForceGetData($forceGetData)
            ->setTillId($tillId);
    }
    /**
     * Get DoNotOpenNewShift value
     * @return bool|null
     */
    public function getDoNotOpenNewShift()
    {
        return $this->DoNotOpenNewShift;
    }
    /**
     * Set DoNotOpenNewShift value
     * @param bool $doNotOpenNewShift
     * @return \patest\StructType\GetCurrentShiftRequest
     */
    public function setDoNotOpenNewShift($doNotOpenNewShift = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotOpenNewShift) && !is_bool($doNotOpenNewShift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotOpenNewShift, true), gettype($doNotOpenNewShift)), __LINE__);
        }
        $this->DoNotOpenNewShift = $doNotOpenNewShift;
        return $this;
    }
    /**
     * Get ForceGetData value
     * @return bool|null
     */
    public function getForceGetData()
    {
        return $this->ForceGetData;
    }
    /**
     * Set ForceGetData value
     * @param bool $forceGetData
     * @return \patest\StructType\GetCurrentShiftRequest
     */
    public function setForceGetData($forceGetData = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceGetData) && !is_bool($forceGetData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceGetData, true), gettype($forceGetData)), __LINE__);
        }
        $this->ForceGetData = $forceGetData;
        return $this;
    }
    /**
     * Get TillId value
     * @return string|null
     */
    public function getTillId()
    {
        return $this->TillId;
    }
    /**
     * Set TillId value
     * @param string $tillId
     * @return \patest\StructType\GetCurrentShiftRequest
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        $this->TillId = $tillId;
        return $this;
    }
}
