<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientWelcomeInfoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientWelcomeInfoRequest
 * @subpackage Structs
 */
class GetClientWelcomeInfoRequest extends ExtensibleDataContract
{
    /**
     * The BringRelatedClientData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BringRelatedClientData;
    /**
     * The WidgetNamesToRetrieve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $WidgetNamesToRetrieve;
    /**
     * Constructor method for GetClientWelcomeInfoRequest
     * @uses GetClientWelcomeInfoRequest::setBringRelatedClientData()
     * @uses GetClientWelcomeInfoRequest::setWidgetNamesToRetrieve()
     * @param bool $bringRelatedClientData
     * @param \patest\ArrayType\ArrayOfstring $widgetNamesToRetrieve
     */
    public function __construct($bringRelatedClientData = null, \patest\ArrayType\ArrayOfstring $widgetNamesToRetrieve = null)
    {
        $this
            ->setBringRelatedClientData($bringRelatedClientData)
            ->setWidgetNamesToRetrieve($widgetNamesToRetrieve);
    }
    /**
     * Get BringRelatedClientData value
     * @return bool|null
     */
    public function getBringRelatedClientData()
    {
        return $this->BringRelatedClientData;
    }
    /**
     * Set BringRelatedClientData value
     * @param bool $bringRelatedClientData
     * @return \patest\StructType\GetClientWelcomeInfoRequest
     */
    public function setBringRelatedClientData($bringRelatedClientData = null)
    {
        // validation for constraint: boolean
        if (!is_null($bringRelatedClientData) && !is_bool($bringRelatedClientData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bringRelatedClientData, true), gettype($bringRelatedClientData)), __LINE__);
        }
        $this->BringRelatedClientData = $bringRelatedClientData;
        return $this;
    }
    /**
     * Get WidgetNamesToRetrieve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getWidgetNamesToRetrieve()
    {
        return isset($this->WidgetNamesToRetrieve) ? $this->WidgetNamesToRetrieve : null;
    }
    /**
     * Set WidgetNamesToRetrieve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $widgetNamesToRetrieve
     * @return \patest\StructType\GetClientWelcomeInfoRequest
     */
    public function setWidgetNamesToRetrieve(\patest\ArrayType\ArrayOfstring $widgetNamesToRetrieve = null)
    {
        if (is_null($widgetNamesToRetrieve) || (is_array($widgetNamesToRetrieve) && empty($widgetNamesToRetrieve))) {
            unset($this->WidgetNamesToRetrieve);
        } else {
            $this->WidgetNamesToRetrieve = $widgetNamesToRetrieve;
        }
        return $this;
    }
}
