<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientLiabilities-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientLiabilities-Request
 * @subpackage Structs
 */
class GetClientLiabilities_Request extends AbstractStructBase
{
    /**
     * The ByClientGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ByClientGroup;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FromSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromSellDate;
    /**
     * The GetActualLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetActualLiabilities;
    /**
     * The GetPendingLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetPendingLiabilities;
    /**
     * The ProductIdsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ProductIdsFilter;
    /**
     * The UntilSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilSellDate;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ItemIds;
    /**
     * The IncludeAllItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeAllItems;
    /**
     * Constructor method for GetClientLiabilities-Request
     * @uses GetClientLiabilities_Request::setByClientGroup()
     * @uses GetClientLiabilities_Request::setClientId()
     * @uses GetClientLiabilities_Request::setFromSellDate()
     * @uses GetClientLiabilities_Request::setGetActualLiabilities()
     * @uses GetClientLiabilities_Request::setGetPendingLiabilities()
     * @uses GetClientLiabilities_Request::setProductIdsFilter()
     * @uses GetClientLiabilities_Request::setUntilSellDate()
     * @uses GetClientLiabilities_Request::setItemIds()
     * @uses GetClientLiabilities_Request::setIncludeAllItems()
     * @param bool $byClientGroup
     * @param string $clientId
     * @param string $fromSellDate
     * @param bool $getActualLiabilities
     * @param bool $getPendingLiabilities
     * @param \patest\ArrayType\ArrayOfguid $productIdsFilter
     * @param string $untilSellDate
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @param bool $includeAllItems
     */
    public function __construct($byClientGroup = null, $clientId = null, $fromSellDate = null, $getActualLiabilities = null, $getPendingLiabilities = null, \patest\ArrayType\ArrayOfguid $productIdsFilter = null, $untilSellDate = null, \patest\ArrayType\ArrayOfguid $itemIds = null, $includeAllItems = null)
    {
        $this
            ->setByClientGroup($byClientGroup)
            ->setClientId($clientId)
            ->setFromSellDate($fromSellDate)
            ->setGetActualLiabilities($getActualLiabilities)
            ->setGetPendingLiabilities($getPendingLiabilities)
            ->setProductIdsFilter($productIdsFilter)
            ->setUntilSellDate($untilSellDate)
            ->setItemIds($itemIds)
            ->setIncludeAllItems($includeAllItems);
    }
    /**
     * Get ByClientGroup value
     * @return bool|null
     */
    public function getByClientGroup()
    {
        return $this->ByClientGroup;
    }
    /**
     * Set ByClientGroup value
     * @param bool $byClientGroup
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setByClientGroup($byClientGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($byClientGroup) && !is_bool($byClientGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byClientGroup, true), gettype($byClientGroup)), __LINE__);
        }
        $this->ByClientGroup = $byClientGroup;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get FromSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromSellDate()
    {
        return isset($this->FromSellDate) ? $this->FromSellDate : null;
    }
    /**
     * Set FromSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromSellDate
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setFromSellDate($fromSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromSellDate) && !is_string($fromSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSellDate, true), gettype($fromSellDate)), __LINE__);
        }
        if (is_null($fromSellDate) || (is_array($fromSellDate) && empty($fromSellDate))) {
            unset($this->FromSellDate);
        } else {
            $this->FromSellDate = $fromSellDate;
        }
        return $this;
    }
    /**
     * Get GetActualLiabilities value
     * @return bool|null
     */
    public function getGetActualLiabilities()
    {
        return $this->GetActualLiabilities;
    }
    /**
     * Set GetActualLiabilities value
     * @param bool $getActualLiabilities
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setGetActualLiabilities($getActualLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($getActualLiabilities) && !is_bool($getActualLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getActualLiabilities, true), gettype($getActualLiabilities)), __LINE__);
        }
        $this->GetActualLiabilities = $getActualLiabilities;
        return $this;
    }
    /**
     * Get GetPendingLiabilities value
     * @return bool|null
     */
    public function getGetPendingLiabilities()
    {
        return $this->GetPendingLiabilities;
    }
    /**
     * Set GetPendingLiabilities value
     * @param bool $getPendingLiabilities
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setGetPendingLiabilities($getPendingLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($getPendingLiabilities) && !is_bool($getPendingLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getPendingLiabilities, true), gettype($getPendingLiabilities)), __LINE__);
        }
        $this->GetPendingLiabilities = $getPendingLiabilities;
        return $this;
    }
    /**
     * Get ProductIdsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getProductIdsFilter()
    {
        return isset($this->ProductIdsFilter) ? $this->ProductIdsFilter : null;
    }
    /**
     * Set ProductIdsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $productIdsFilter
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setProductIdsFilter(\patest\ArrayType\ArrayOfguid $productIdsFilter = null)
    {
        if (is_null($productIdsFilter) || (is_array($productIdsFilter) && empty($productIdsFilter))) {
            unset($this->ProductIdsFilter);
        } else {
            $this->ProductIdsFilter = $productIdsFilter;
        }
        return $this;
    }
    /**
     * Get UntilSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilSellDate()
    {
        return isset($this->UntilSellDate) ? $this->UntilSellDate : null;
    }
    /**
     * Set UntilSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilSellDate
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setUntilSellDate($untilSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilSellDate) && !is_string($untilSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilSellDate, true), gettype($untilSellDate)), __LINE__);
        }
        if (is_null($untilSellDate) || (is_array($untilSellDate) && empty($untilSellDate))) {
            unset($this->UntilSellDate);
        } else {
            $this->UntilSellDate = $untilSellDate;
        }
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfguid $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get IncludeAllItems value
     * @return bool|null
     */
    public function getIncludeAllItems()
    {
        return $this->IncludeAllItems;
    }
    /**
     * Set IncludeAllItems value
     * @param bool $includeAllItems
     * @return \patest\StructType\GetClientLiabilities_Request
     */
    public function setIncludeAllItems($includeAllItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAllItems) && !is_bool($includeAllItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAllItems, true), gettype($includeAllItems)), __LINE__);
        }
        $this->IncludeAllItems = $includeAllItems;
        return $this;
    }
}
