<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClassNodesRequest-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClassNodesRequest-Request
 * @subpackage Structs
 */
class GetClassNodesRequest_Request extends AbstractStructBase
{
    /**
     * The ClassTreeLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ClassTreeLevel;
    /**
     * The IncludeMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeMedia;
    /**
     * The VisibleOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisibleOnly;
    /**
     * Constructor method for GetClassNodesRequest-Request
     * @uses GetClassNodesRequest_Request::setClassTreeLevel()
     * @uses GetClassNodesRequest_Request::setIncludeMedia()
     * @uses GetClassNodesRequest_Request::setVisibleOnly()
     * @param string[] $classTreeLevel
     * @param bool $includeMedia
     * @param bool $visibleOnly
     */
    public function __construct(array $classTreeLevel = array(), $includeMedia = null, $visibleOnly = null)
    {
        $this
            ->setClassTreeLevel($classTreeLevel)
            ->setIncludeMedia($includeMedia)
            ->setVisibleOnly($visibleOnly);
    }
    /**
     * Get ClassTreeLevel value
     * @return string[]|null
     */
    public function getClassTreeLevel()
    {
        return $this->ClassTreeLevel;
    }
    /**
     * This method is responsible for validating the values passed to the setClassTreeLevel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassTreeLevel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassTreeLevelForArrayConstraintsFromSetClassTreeLevel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getClassNodesRequest_RequestClassTreeLevelItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ClassTreeLevel::valueIsValid($getClassNodesRequest_RequestClassTreeLevelItem)) {
                $invalidValues[] = is_object($getClassNodesRequest_RequestClassTreeLevelItem) ? get_class($getClassNodesRequest_RequestClassTreeLevelItem) : sprintf('%s(%s)', gettype($getClassNodesRequest_RequestClassTreeLevelItem), var_export($getClassNodesRequest_RequestClassTreeLevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClassTreeLevel', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ClassTreeLevel::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClassTreeLevel value
     * @uses \patest\EnumType\ClassTreeLevel::valueIsValid()
     * @uses \patest\EnumType\ClassTreeLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $classTreeLevel
     * @return \patest\StructType\GetClassNodesRequest_Request
     */
    public function setClassTreeLevel(array $classTreeLevel = array())
    {
        // validation for constraint: list
        if ('' !== ($classTreeLevelArrayErrorMessage = self::validateClassTreeLevelForArrayConstraintsFromSetClassTreeLevel($classTreeLevel))) {
            throw new \InvalidArgumentException($classTreeLevelArrayErrorMessage, __LINE__);
        }
        $this->ClassTreeLevel = is_array($classTreeLevel) ? implode(' ', $classTreeLevel) : null;
        return $this;
    }
    /**
     * Get IncludeMedia value
     * @return bool|null
     */
    public function getIncludeMedia()
    {
        return $this->IncludeMedia;
    }
    /**
     * Set IncludeMedia value
     * @param bool $includeMedia
     * @return \patest\StructType\GetClassNodesRequest_Request
     */
    public function setIncludeMedia($includeMedia = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMedia) && !is_bool($includeMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMedia, true), gettype($includeMedia)), __LINE__);
        }
        $this->IncludeMedia = $includeMedia;
        return $this;
    }
    /**
     * Get VisibleOnly value
     * @return bool|null
     */
    public function getVisibleOnly()
    {
        return $this->VisibleOnly;
    }
    /**
     * Set VisibleOnly value
     * @param bool $visibleOnly
     * @return \patest\StructType\GetClassNodesRequest_Request
     */
    public function setVisibleOnly($visibleOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleOnly) && !is_bool($visibleOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleOnly, true), gettype($visibleOnly)), __LINE__);
        }
        $this->VisibleOnly = $visibleOnly;
        return $this;
    }
}
