<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBundleElementAvailableProductsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBundleElementAvailableProductsRequest
 * @subpackage Structs
 */
class GetBundleElementAvailableProductsRequest extends ExtensibleDataContract
{
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The ElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ElementId;
    /**
     * The ElementTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementTypeName;
    /**
     * The ForDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForDate;
    /**
     * The QuantityOfBundles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfBundles;
    /**
     * Constructor method for GetBundleElementAvailableProductsRequest
     * @uses GetBundleElementAvailableProductsRequest::setBundleId()
     * @uses GetBundleElementAvailableProductsRequest::setElementId()
     * @uses GetBundleElementAvailableProductsRequest::setElementTypeName()
     * @uses GetBundleElementAvailableProductsRequest::setForDate()
     * @uses GetBundleElementAvailableProductsRequest::setQuantityOfBundles()
     * @param string $bundleId
     * @param string $elementId
     * @param string $elementTypeName
     * @param string $forDate
     * @param int $quantityOfBundles
     */
    public function __construct($bundleId = null, $elementId = null, $elementTypeName = null, $forDate = null, $quantityOfBundles = null)
    {
        $this
            ->setBundleId($bundleId)
            ->setElementId($elementId)
            ->setElementTypeName($elementTypeName)
            ->setForDate($forDate)
            ->setQuantityOfBundles($quantityOfBundles);
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\GetBundleElementAvailableProductsRequest
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get ElementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->ElementId;
    }
    /**
     * Set ElementId value
     * @param string $elementId
     * @return \patest\StructType\GetBundleElementAvailableProductsRequest
     */
    public function setElementId($elementId = null)
    {
        // validation for constraint: string
        if (!is_null($elementId) && !is_string($elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementId, true), gettype($elementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($elementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($elementId, true)), __LINE__);
        }
        $this->ElementId = $elementId;
        return $this;
    }
    /**
     * Get ElementTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementTypeName()
    {
        return isset($this->ElementTypeName) ? $this->ElementTypeName : null;
    }
    /**
     * Set ElementTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementTypeName
     * @return \patest\StructType\GetBundleElementAvailableProductsRequest
     */
    public function setElementTypeName($elementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($elementTypeName) && !is_string($elementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementTypeName, true), gettype($elementTypeName)), __LINE__);
        }
        if (is_null($elementTypeName) || (is_array($elementTypeName) && empty($elementTypeName))) {
            unset($this->ElementTypeName);
        } else {
            $this->ElementTypeName = $elementTypeName;
        }
        return $this;
    }
    /**
     * Get ForDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForDate()
    {
        return isset($this->ForDate) ? $this->ForDate : null;
    }
    /**
     * Set ForDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forDate
     * @return \patest\StructType\GetBundleElementAvailableProductsRequest
     */
    public function setForDate($forDate = null)
    {
        // validation for constraint: string
        if (!is_null($forDate) && !is_string($forDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forDate, true), gettype($forDate)), __LINE__);
        }
        if (is_null($forDate) || (is_array($forDate) && empty($forDate))) {
            unset($this->ForDate);
        } else {
            $this->ForDate = $forDate;
        }
        return $this;
    }
    /**
     * Get QuantityOfBundles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfBundles()
    {
        return isset($this->QuantityOfBundles) ? $this->QuantityOfBundles : null;
    }
    /**
     * Set QuantityOfBundles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfBundles
     * @return \patest\StructType\GetBundleElementAvailableProductsRequest
     */
    public function setQuantityOfBundles($quantityOfBundles = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfBundles) && !(is_int($quantityOfBundles) || ctype_digit($quantityOfBundles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfBundles, true), gettype($quantityOfBundles)), __LINE__);
        }
        if (is_null($quantityOfBundles) || (is_array($quantityOfBundles) && empty($quantityOfBundles))) {
            unset($this->QuantityOfBundles);
        } else {
            $this->QuantityOfBundles = $quantityOfBundles;
        }
        return $this;
    }
}
