<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBundleAvailableDatesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBundleAvailableDatesRequest
 * @subpackage Structs
 */
class GetBundleAvailableDatesRequest extends ExtensibleDataContract
{
    /**
     * The BringNearestDateOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BringNearestDateOnly;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The QuantityOfBundles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfBundles;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for GetBundleAvailableDatesRequest
     * @uses GetBundleAvailableDatesRequest::setBringNearestDateOnly()
     * @uses GetBundleAvailableDatesRequest::setBundleId()
     * @uses GetBundleAvailableDatesRequest::setFromDate()
     * @uses GetBundleAvailableDatesRequest::setQuantityOfBundles()
     * @uses GetBundleAvailableDatesRequest::setToDate()
     * @param bool $bringNearestDateOnly
     * @param string $bundleId
     * @param string $fromDate
     * @param int $quantityOfBundles
     * @param string $toDate
     */
    public function __construct($bringNearestDateOnly = null, $bundleId = null, $fromDate = null, $quantityOfBundles = null, $toDate = null)
    {
        $this
            ->setBringNearestDateOnly($bringNearestDateOnly)
            ->setBundleId($bundleId)
            ->setFromDate($fromDate)
            ->setQuantityOfBundles($quantityOfBundles)
            ->setToDate($toDate);
    }
    /**
     * Get BringNearestDateOnly value
     * @return bool|null
     */
    public function getBringNearestDateOnly()
    {
        return $this->BringNearestDateOnly;
    }
    /**
     * Set BringNearestDateOnly value
     * @param bool $bringNearestDateOnly
     * @return \patest\StructType\GetBundleAvailableDatesRequest
     */
    public function setBringNearestDateOnly($bringNearestDateOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($bringNearestDateOnly) && !is_bool($bringNearestDateOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bringNearestDateOnly, true), gettype($bringNearestDateOnly)), __LINE__);
        }
        $this->BringNearestDateOnly = $bringNearestDateOnly;
        return $this;
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\GetBundleAvailableDatesRequest
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\GetBundleAvailableDatesRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get QuantityOfBundles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfBundles()
    {
        return isset($this->QuantityOfBundles) ? $this->QuantityOfBundles : null;
    }
    /**
     * Set QuantityOfBundles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfBundles
     * @return \patest\StructType\GetBundleAvailableDatesRequest
     */
    public function setQuantityOfBundles($quantityOfBundles = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfBundles) && !(is_int($quantityOfBundles) || ctype_digit($quantityOfBundles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfBundles, true), gettype($quantityOfBundles)), __LINE__);
        }
        if (is_null($quantityOfBundles) || (is_array($quantityOfBundles) && empty($quantityOfBundles))) {
            unset($this->QuantityOfBundles);
        } else {
            $this->QuantityOfBundles = $quantityOfBundles;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\GetBundleAvailableDatesRequest
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
