<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableShows-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableShows-Response
 * @subpackage Structs
 */
class GetAvailableShows_Response extends ExtensibleDataContract
{
    /**
     * The Shows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfShowDescription
     */
    public $Shows;
    /**
     * Constructor method for GetAvailableShows-Response
     * @uses GetAvailableShows_Response::setShows()
     * @param \patest\ArrayType\ArrayOfShowDescription $shows
     */
    public function __construct(\patest\ArrayType\ArrayOfShowDescription $shows = null)
    {
        $this
            ->setShows($shows);
    }
    /**
     * Get Shows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfShowDescription|null
     */
    public function getShows()
    {
        return isset($this->Shows) ? $this->Shows : null;
    }
    /**
     * Set Shows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfShowDescription $shows
     * @return \patest\StructType\GetAvailableShows_Response
     */
    public function setShows(\patest\ArrayType\ArrayOfShowDescription $shows = null)
    {
        if (is_null($shows) || (is_array($shows) && empty($shows))) {
            unset($this->Shows);
        } else {
            $this->Shows = $shows;
        }
        return $this;
    }
}
