<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailablePrintOptionsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailablePrintOptionsResponse
 * @subpackage Structs
 */
class GetAvailablePrintOptionsResponse extends ExtensibleDataContract
{
    /**
     * The AvailablePrintOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAvailablePrintOption
     */
    public $AvailablePrintOptions;
    /**
     * The NothingToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NothingToPrint;
    /**
     * Constructor method for GetAvailablePrintOptionsResponse
     * @uses GetAvailablePrintOptionsResponse::setAvailablePrintOptions()
     * @uses GetAvailablePrintOptionsResponse::setNothingToPrint()
     * @param \patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions
     * @param bool $nothingToPrint
     */
    public function __construct(\patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions = null, $nothingToPrint = null)
    {
        $this
            ->setAvailablePrintOptions($availablePrintOptions)
            ->setNothingToPrint($nothingToPrint);
    }
    /**
     * Get AvailablePrintOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAvailablePrintOption|null
     */
    public function getAvailablePrintOptions()
    {
        return isset($this->AvailablePrintOptions) ? $this->AvailablePrintOptions : null;
    }
    /**
     * Set AvailablePrintOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions
     * @return \patest\StructType\GetAvailablePrintOptionsResponse
     */
    public function setAvailablePrintOptions(\patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions = null)
    {
        if (is_null($availablePrintOptions) || (is_array($availablePrintOptions) && empty($availablePrintOptions))) {
            unset($this->AvailablePrintOptions);
        } else {
            $this->AvailablePrintOptions = $availablePrintOptions;
        }
        return $this;
    }
    /**
     * Get NothingToPrint value
     * @return bool|null
     */
    public function getNothingToPrint()
    {
        return $this->NothingToPrint;
    }
    /**
     * Set NothingToPrint value
     * @param bool $nothingToPrint
     * @return \patest\StructType\GetAvailablePrintOptionsResponse
     */
    public function setNothingToPrint($nothingToPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($nothingToPrint) && !is_bool($nothingToPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nothingToPrint, true), gettype($nothingToPrint)), __LINE__);
        }
        $this->NothingToPrint = $nothingToPrint;
        return $this;
    }
}
