<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableEvents-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableEvents-Request
 * @subpackage Structs
 */
class GetAvailableEvents_Request extends ExtensibleDataContract
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IncludeClosedForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeClosedForSale;
    /**
     * The IncludeDisplayableFutureSales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDisplayableFutureSales;
    /**
     * The MaxResultCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResultCount;
    /**
     * The MaxResultCountPerShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResultCountPerShow;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The AssociatedDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateFrom;
    /**
     * The AssociatedDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateTo;
    /**
     * The FullDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FullDetails;
    /**
     * The ModifiedSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifiedSince;
    /**
     * The CompactMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CompactMode;
    /**
     * The IncludeAvailabilityInSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeAvailabilityInSeries;
    /**
     * The GenreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenreId;
    /**
     * The RecommendedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecommendedOnly;
    /**
     * The FilterByShowTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterByShowTypeIds;
    /**
     * The ShowTypesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ShowTypesIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * The IncludeAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeAvailability;
    /**
     * The IncludeEventTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventTags;
    /**
     * The OnlyHospitalityEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyHospitalityEvents;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The IsSupportingMarketDrivenResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupportingMarketDrivenResalePolicy;
    /**
     * The IsTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTour;
    /**
     * The AvailableForFullStackExchangesInSeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AvailableForFullStackExchangesInSeriesIds;
    /**
     * The TagSystemNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $TagSystemNames;
    /**
     * The ExchangeOutTicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ExchangeOutTicketIds;
    /**
     * The BringOnlyEventsLinkedTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $BringOnlyEventsLinkedTo;
    /**
     * The FilterByAddOnType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterByAddOnType;
    /**
     * The IncludeLimitationRuleInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeLimitationRuleInfo;
    /**
     * Constructor method for GetAvailableEvents-Request
     * @uses GetAvailableEvents_Request::setFromDate()
     * @uses GetAvailableEvents_Request::setIncludeClosedForSale()
     * @uses GetAvailableEvents_Request::setIncludeDisplayableFutureSales()
     * @uses GetAvailableEvents_Request::setMaxResultCount()
     * @uses GetAvailableEvents_Request::setMaxResultCountPerShow()
     * @uses GetAvailableEvents_Request::setShowId()
     * @uses GetAvailableEvents_Request::setToDate()
     * @uses GetAvailableEvents_Request::setAssociatedDateFrom()
     * @uses GetAvailableEvents_Request::setAssociatedDateTo()
     * @uses GetAvailableEvents_Request::setFullDetails()
     * @uses GetAvailableEvents_Request::setModifiedSince()
     * @uses GetAvailableEvents_Request::setCompactMode()
     * @uses GetAvailableEvents_Request::setIncludeAvailabilityInSeries()
     * @uses GetAvailableEvents_Request::setGenreId()
     * @uses GetAvailableEvents_Request::setRecommendedOnly()
     * @uses GetAvailableEvents_Request::setFilterByShowTypeIds()
     * @uses GetAvailableEvents_Request::setShowTypesIds()
     * @uses GetAvailableEvents_Request::setHallId()
     * @uses GetAvailableEvents_Request::setVenueId()
     * @uses GetAvailableEvents_Request::setIncludeAvailability()
     * @uses GetAvailableEvents_Request::setIncludeEventTags()
     * @uses GetAvailableEvents_Request::setOnlyHospitalityEvents()
     * @uses GetAvailableEvents_Request::setCouponIdentity()
     * @uses GetAvailableEvents_Request::setIsSupportingMarketDrivenResalePolicy()
     * @uses GetAvailableEvents_Request::setIsTour()
     * @uses GetAvailableEvents_Request::setAvailableForFullStackExchangesInSeriesIds()
     * @uses GetAvailableEvents_Request::setTagSystemNames()
     * @uses GetAvailableEvents_Request::setExchangeOutTicketIds()
     * @uses GetAvailableEvents_Request::setBringOnlyEventsLinkedTo()
     * @uses GetAvailableEvents_Request::setFilterByAddOnType()
     * @uses GetAvailableEvents_Request::setIncludeLimitationRuleInfo()
     * @param string $fromDate
     * @param bool $includeClosedForSale
     * @param bool $includeDisplayableFutureSales
     * @param int $maxResultCount
     * @param int $maxResultCountPerShow
     * @param string $showId
     * @param string $toDate
     * @param string $associatedDateFrom
     * @param string $associatedDateTo
     * @param bool $fullDetails
     * @param string $modifiedSince
     * @param bool $compactMode
     * @param bool $includeAvailabilityInSeries
     * @param string $genreId
     * @param string $recommendedOnly
     * @param bool $filterByShowTypeIds
     * @param \patest\ArrayType\ArrayOfguid $showTypesIds
     * @param string $hallId
     * @param string $venueId
     * @param bool $includeAvailability
     * @param bool $includeEventTags
     * @param bool $onlyHospitalityEvents
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @param bool $isTour
     * @param \patest\ArrayType\ArrayOfguid $availableForFullStackExchangesInSeriesIds
     * @param \patest\ArrayType\ArrayOfstring $tagSystemNames
     * @param \patest\ArrayType\ArrayOfguid $exchangeOutTicketIds
     * @param \patest\ArrayType\ArrayOfguid $bringOnlyEventsLinkedTo
     * @param string $filterByAddOnType
     * @param bool $includeLimitationRuleInfo
     */
    public function __construct($fromDate = null, $includeClosedForSale = null, $includeDisplayableFutureSales = null, $maxResultCount = null, $maxResultCountPerShow = null, $showId = null, $toDate = null, $associatedDateFrom = null, $associatedDateTo = null, $fullDetails = null, $modifiedSince = null, $compactMode = null, $includeAvailabilityInSeries = null, $genreId = null, $recommendedOnly = null, $filterByShowTypeIds = null, \patest\ArrayType\ArrayOfguid $showTypesIds = null, $hallId = null, $venueId = null, $includeAvailability = null, $includeEventTags = null, $onlyHospitalityEvents = null, \patest\StructType\CouponIdentity $couponIdentity = null, $isSupportingMarketDrivenResalePolicy = null, $isTour = null, \patest\ArrayType\ArrayOfguid $availableForFullStackExchangesInSeriesIds = null, \patest\ArrayType\ArrayOfstring $tagSystemNames = null, \patest\ArrayType\ArrayOfguid $exchangeOutTicketIds = null, \patest\ArrayType\ArrayOfguid $bringOnlyEventsLinkedTo = null, $filterByAddOnType = null, $includeLimitationRuleInfo = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setIncludeClosedForSale($includeClosedForSale)
            ->setIncludeDisplayableFutureSales($includeDisplayableFutureSales)
            ->setMaxResultCount($maxResultCount)
            ->setMaxResultCountPerShow($maxResultCountPerShow)
            ->setShowId($showId)
            ->setToDate($toDate)
            ->setAssociatedDateFrom($associatedDateFrom)
            ->setAssociatedDateTo($associatedDateTo)
            ->setFullDetails($fullDetails)
            ->setModifiedSince($modifiedSince)
            ->setCompactMode($compactMode)
            ->setIncludeAvailabilityInSeries($includeAvailabilityInSeries)
            ->setGenreId($genreId)
            ->setRecommendedOnly($recommendedOnly)
            ->setFilterByShowTypeIds($filterByShowTypeIds)
            ->setShowTypesIds($showTypesIds)
            ->setHallId($hallId)
            ->setVenueId($venueId)
            ->setIncludeAvailability($includeAvailability)
            ->setIncludeEventTags($includeEventTags)
            ->setOnlyHospitalityEvents($onlyHospitalityEvents)
            ->setCouponIdentity($couponIdentity)
            ->setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy)
            ->setIsTour($isTour)
            ->setAvailableForFullStackExchangesInSeriesIds($availableForFullStackExchangesInSeriesIds)
            ->setTagSystemNames($tagSystemNames)
            ->setExchangeOutTicketIds($exchangeOutTicketIds)
            ->setBringOnlyEventsLinkedTo($bringOnlyEventsLinkedTo)
            ->setFilterByAddOnType($filterByAddOnType)
            ->setIncludeLimitationRuleInfo($includeLimitationRuleInfo);
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IncludeClosedForSale value
     * @return bool|null
     */
    public function getIncludeClosedForSale()
    {
        return $this->IncludeClosedForSale;
    }
    /**
     * Set IncludeClosedForSale value
     * @param bool $includeClosedForSale
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeClosedForSale($includeClosedForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeClosedForSale) && !is_bool($includeClosedForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeClosedForSale, true), gettype($includeClosedForSale)), __LINE__);
        }
        $this->IncludeClosedForSale = $includeClosedForSale;
        return $this;
    }
    /**
     * Get IncludeDisplayableFutureSales value
     * @return bool|null
     */
    public function getIncludeDisplayableFutureSales()
    {
        return $this->IncludeDisplayableFutureSales;
    }
    /**
     * Set IncludeDisplayableFutureSales value
     * @param bool $includeDisplayableFutureSales
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeDisplayableFutureSales($includeDisplayableFutureSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDisplayableFutureSales) && !is_bool($includeDisplayableFutureSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDisplayableFutureSales, true), gettype($includeDisplayableFutureSales)), __LINE__);
        }
        $this->IncludeDisplayableFutureSales = $includeDisplayableFutureSales;
        return $this;
    }
    /**
     * Get MaxResultCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return isset($this->MaxResultCount) ? $this->MaxResultCount : null;
    }
    /**
     * Set MaxResultCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResultCount
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultCount) && !(is_int($maxResultCount) || ctype_digit($maxResultCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultCount, true), gettype($maxResultCount)), __LINE__);
        }
        if (is_null($maxResultCount) || (is_array($maxResultCount) && empty($maxResultCount))) {
            unset($this->MaxResultCount);
        } else {
            $this->MaxResultCount = $maxResultCount;
        }
        return $this;
    }
    /**
     * Get MaxResultCountPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResultCountPerShow()
    {
        return isset($this->MaxResultCountPerShow) ? $this->MaxResultCountPerShow : null;
    }
    /**
     * Set MaxResultCountPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResultCountPerShow
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setMaxResultCountPerShow($maxResultCountPerShow = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultCountPerShow) && !(is_int($maxResultCountPerShow) || ctype_digit($maxResultCountPerShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultCountPerShow, true), gettype($maxResultCountPerShow)), __LINE__);
        }
        if (is_null($maxResultCountPerShow) || (is_array($maxResultCountPerShow) && empty($maxResultCountPerShow))) {
            unset($this->MaxResultCountPerShow);
        } else {
            $this->MaxResultCountPerShow = $maxResultCountPerShow;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get AssociatedDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateFrom()
    {
        return isset($this->AssociatedDateFrom) ? $this->AssociatedDateFrom : null;
    }
    /**
     * Set AssociatedDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateFrom
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setAssociatedDateFrom($associatedDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateFrom) && !is_string($associatedDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateFrom, true), gettype($associatedDateFrom)), __LINE__);
        }
        if (is_null($associatedDateFrom) || (is_array($associatedDateFrom) && empty($associatedDateFrom))) {
            unset($this->AssociatedDateFrom);
        } else {
            $this->AssociatedDateFrom = $associatedDateFrom;
        }
        return $this;
    }
    /**
     * Get AssociatedDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateTo()
    {
        return isset($this->AssociatedDateTo) ? $this->AssociatedDateTo : null;
    }
    /**
     * Set AssociatedDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateTo
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setAssociatedDateTo($associatedDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateTo) && !is_string($associatedDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateTo, true), gettype($associatedDateTo)), __LINE__);
        }
        if (is_null($associatedDateTo) || (is_array($associatedDateTo) && empty($associatedDateTo))) {
            unset($this->AssociatedDateTo);
        } else {
            $this->AssociatedDateTo = $associatedDateTo;
        }
        return $this;
    }
    /**
     * Get FullDetails value
     * @return bool|null
     */
    public function getFullDetails()
    {
        return $this->FullDetails;
    }
    /**
     * Set FullDetails value
     * @param bool $fullDetails
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setFullDetails($fullDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullDetails) && !is_bool($fullDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullDetails, true), gettype($fullDetails)), __LINE__);
        }
        $this->FullDetails = $fullDetails;
        return $this;
    }
    /**
     * Get ModifiedSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifiedSince()
    {
        return isset($this->ModifiedSince) ? $this->ModifiedSince : null;
    }
    /**
     * Set ModifiedSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifiedSince
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setModifiedSince($modifiedSince = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedSince) && !is_string($modifiedSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedSince, true), gettype($modifiedSince)), __LINE__);
        }
        if (is_null($modifiedSince) || (is_array($modifiedSince) && empty($modifiedSince))) {
            unset($this->ModifiedSince);
        } else {
            $this->ModifiedSince = $modifiedSince;
        }
        return $this;
    }
    /**
     * Get CompactMode value
     * @return bool|null
     */
    public function getCompactMode()
    {
        return $this->CompactMode;
    }
    /**
     * Set CompactMode value
     * @param bool $compactMode
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setCompactMode($compactMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($compactMode) && !is_bool($compactMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compactMode, true), gettype($compactMode)), __LINE__);
        }
        $this->CompactMode = $compactMode;
        return $this;
    }
    /**
     * Get IncludeAvailabilityInSeries value
     * @return bool|null
     */
    public function getIncludeAvailabilityInSeries()
    {
        return $this->IncludeAvailabilityInSeries;
    }
    /**
     * Set IncludeAvailabilityInSeries value
     * @param bool $includeAvailabilityInSeries
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeAvailabilityInSeries($includeAvailabilityInSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAvailabilityInSeries) && !is_bool($includeAvailabilityInSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAvailabilityInSeries, true), gettype($includeAvailabilityInSeries)), __LINE__);
        }
        $this->IncludeAvailabilityInSeries = $includeAvailabilityInSeries;
        return $this;
    }
    /**
     * Get GenreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenreId()
    {
        return isset($this->GenreId) ? $this->GenreId : null;
    }
    /**
     * Set GenreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genreId
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genreId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genreId, true)), __LINE__);
        }
        if (is_null($genreId) || (is_array($genreId) && empty($genreId))) {
            unset($this->GenreId);
        } else {
            $this->GenreId = $genreId;
        }
        return $this;
    }
    /**
     * Get RecommendedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecommendedOnly()
    {
        return isset($this->RecommendedOnly) ? $this->RecommendedOnly : null;
    }
    /**
     * Set RecommendedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ShowRecommendationScope::valueIsValid()
     * @uses \patest\EnumType\ShowRecommendationScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recommendedOnly
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setRecommendedOnly($recommendedOnly = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ShowRecommendationScope::valueIsValid($recommendedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ShowRecommendationScope', is_array($recommendedOnly) ? implode(', ', $recommendedOnly) : var_export($recommendedOnly, true), implode(', ', \patest\EnumType\ShowRecommendationScope::getValidValues())), __LINE__);
        }
        if (is_null($recommendedOnly) || (is_array($recommendedOnly) && empty($recommendedOnly))) {
            unset($this->RecommendedOnly);
        } else {
            $this->RecommendedOnly = $recommendedOnly;
        }
        return $this;
    }
    /**
     * Get FilterByShowTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterByShowTypeIds()
    {
        return isset($this->FilterByShowTypeIds) ? $this->FilterByShowTypeIds : null;
    }
    /**
     * Set FilterByShowTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterByShowTypeIds
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setFilterByShowTypeIds($filterByShowTypeIds = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByShowTypeIds) && !is_bool($filterByShowTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterByShowTypeIds, true), gettype($filterByShowTypeIds)), __LINE__);
        }
        if (is_null($filterByShowTypeIds) || (is_array($filterByShowTypeIds) && empty($filterByShowTypeIds))) {
            unset($this->FilterByShowTypeIds);
        } else {
            $this->FilterByShowTypeIds = $filterByShowTypeIds;
        }
        return $this;
    }
    /**
     * Get ShowTypesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getShowTypesIds()
    {
        return isset($this->ShowTypesIds) ? $this->ShowTypesIds : null;
    }
    /**
     * Set ShowTypesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $showTypesIds
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setShowTypesIds(\patest\ArrayType\ArrayOfguid $showTypesIds = null)
    {
        if (is_null($showTypesIds) || (is_array($showTypesIds) && empty($showTypesIds))) {
            unset($this->ShowTypesIds);
        } else {
            $this->ShowTypesIds = $showTypesIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
    /**
     * Get IncludeAvailability value
     * @return bool|null
     */
    public function getIncludeAvailability()
    {
        return $this->IncludeAvailability;
    }
    /**
     * Set IncludeAvailability value
     * @param bool $includeAvailability
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeAvailability($includeAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAvailability) && !is_bool($includeAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAvailability, true), gettype($includeAvailability)), __LINE__);
        }
        $this->IncludeAvailability = $includeAvailability;
        return $this;
    }
    /**
     * Get IncludeEventTags value
     * @return bool|null
     */
    public function getIncludeEventTags()
    {
        return $this->IncludeEventTags;
    }
    /**
     * Set IncludeEventTags value
     * @param bool $includeEventTags
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeEventTags($includeEventTags = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventTags) && !is_bool($includeEventTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventTags, true), gettype($includeEventTags)), __LINE__);
        }
        $this->IncludeEventTags = $includeEventTags;
        return $this;
    }
    /**
     * Get OnlyHospitalityEvents value
     * @return bool|null
     */
    public function getOnlyHospitalityEvents()
    {
        return $this->OnlyHospitalityEvents;
    }
    /**
     * Set OnlyHospitalityEvents value
     * @param bool $onlyHospitalityEvents
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setOnlyHospitalityEvents($onlyHospitalityEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyHospitalityEvents) && !is_bool($onlyHospitalityEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyHospitalityEvents, true), gettype($onlyHospitalityEvents)), __LINE__);
        }
        $this->OnlyHospitalityEvents = $onlyHospitalityEvents;
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get IsSupportingMarketDrivenResalePolicy value
     * @return bool|null
     */
    public function getIsSupportingMarketDrivenResalePolicy()
    {
        return $this->IsSupportingMarketDrivenResalePolicy;
    }
    /**
     * Set IsSupportingMarketDrivenResalePolicy value
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportingMarketDrivenResalePolicy) && !is_bool($isSupportingMarketDrivenResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportingMarketDrivenResalePolicy, true), gettype($isSupportingMarketDrivenResalePolicy)), __LINE__);
        }
        $this->IsSupportingMarketDrivenResalePolicy = $isSupportingMarketDrivenResalePolicy;
        return $this;
    }
    /**
     * Get IsTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTour()
    {
        return isset($this->IsTour) ? $this->IsTour : null;
    }
    /**
     * Set IsTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTour
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIsTour($isTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTour) && !is_bool($isTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTour, true), gettype($isTour)), __LINE__);
        }
        if (is_null($isTour) || (is_array($isTour) && empty($isTour))) {
            unset($this->IsTour);
        } else {
            $this->IsTour = $isTour;
        }
        return $this;
    }
    /**
     * Get AvailableForFullStackExchangesInSeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAvailableForFullStackExchangesInSeriesIds()
    {
        return isset($this->AvailableForFullStackExchangesInSeriesIds) ? $this->AvailableForFullStackExchangesInSeriesIds : null;
    }
    /**
     * Set AvailableForFullStackExchangesInSeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $availableForFullStackExchangesInSeriesIds
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setAvailableForFullStackExchangesInSeriesIds(\patest\ArrayType\ArrayOfguid $availableForFullStackExchangesInSeriesIds = null)
    {
        if (is_null($availableForFullStackExchangesInSeriesIds) || (is_array($availableForFullStackExchangesInSeriesIds) && empty($availableForFullStackExchangesInSeriesIds))) {
            unset($this->AvailableForFullStackExchangesInSeriesIds);
        } else {
            $this->AvailableForFullStackExchangesInSeriesIds = $availableForFullStackExchangesInSeriesIds;
        }
        return $this;
    }
    /**
     * Get TagSystemNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getTagSystemNames()
    {
        return isset($this->TagSystemNames) ? $this->TagSystemNames : null;
    }
    /**
     * Set TagSystemNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $tagSystemNames
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setTagSystemNames(\patest\ArrayType\ArrayOfstring $tagSystemNames = null)
    {
        if (is_null($tagSystemNames) || (is_array($tagSystemNames) && empty($tagSystemNames))) {
            unset($this->TagSystemNames);
        } else {
            $this->TagSystemNames = $tagSystemNames;
        }
        return $this;
    }
    /**
     * Get ExchangeOutTicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getExchangeOutTicketIds()
    {
        return isset($this->ExchangeOutTicketIds) ? $this->ExchangeOutTicketIds : null;
    }
    /**
     * Set ExchangeOutTicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $exchangeOutTicketIds
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setExchangeOutTicketIds(\patest\ArrayType\ArrayOfguid $exchangeOutTicketIds = null)
    {
        if (is_null($exchangeOutTicketIds) || (is_array($exchangeOutTicketIds) && empty($exchangeOutTicketIds))) {
            unset($this->ExchangeOutTicketIds);
        } else {
            $this->ExchangeOutTicketIds = $exchangeOutTicketIds;
        }
        return $this;
    }
    /**
     * Get BringOnlyEventsLinkedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getBringOnlyEventsLinkedTo()
    {
        return isset($this->BringOnlyEventsLinkedTo) ? $this->BringOnlyEventsLinkedTo : null;
    }
    /**
     * Set BringOnlyEventsLinkedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $bringOnlyEventsLinkedTo
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setBringOnlyEventsLinkedTo(\patest\ArrayType\ArrayOfguid $bringOnlyEventsLinkedTo = null)
    {
        if (is_null($bringOnlyEventsLinkedTo) || (is_array($bringOnlyEventsLinkedTo) && empty($bringOnlyEventsLinkedTo))) {
            unset($this->BringOnlyEventsLinkedTo);
        } else {
            $this->BringOnlyEventsLinkedTo = $bringOnlyEventsLinkedTo;
        }
        return $this;
    }
    /**
     * Get FilterByAddOnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterByAddOnType()
    {
        return isset($this->FilterByAddOnType) ? $this->FilterByAddOnType : null;
    }
    /**
     * Set FilterByAddOnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventAddOnClassification::valueIsValid()
     * @uses \patest\EnumType\EventAddOnClassification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterByAddOnType
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setFilterByAddOnType($filterByAddOnType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventAddOnClassification::valueIsValid($filterByAddOnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventAddOnClassification', is_array($filterByAddOnType) ? implode(', ', $filterByAddOnType) : var_export($filterByAddOnType, true), implode(', ', \patest\EnumType\EventAddOnClassification::getValidValues())), __LINE__);
        }
        if (is_null($filterByAddOnType) || (is_array($filterByAddOnType) && empty($filterByAddOnType))) {
            unset($this->FilterByAddOnType);
        } else {
            $this->FilterByAddOnType = $filterByAddOnType;
        }
        return $this;
    }
    /**
     * Get IncludeLimitationRuleInfo value
     * @return bool|null
     */
    public function getIncludeLimitationRuleInfo()
    {
        return $this->IncludeLimitationRuleInfo;
    }
    /**
     * Set IncludeLimitationRuleInfo value
     * @param bool $includeLimitationRuleInfo
     * @return \patest\StructType\GetAvailableEvents_Request
     */
    public function setIncludeLimitationRuleInfo($includeLimitationRuleInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeLimitationRuleInfo) && !is_bool($includeLimitationRuleInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeLimitationRuleInfo, true), gettype($includeLimitationRuleInfo)), __LINE__);
        }
        $this->IncludeLimitationRuleInfo = $includeLimitationRuleInfo;
        return $this;
    }
}
