<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableDataRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableDataRequest
 * @subpackage Structs
 */
class GetAvailableDataRequest extends AbstractStructBase
{
    /**
     * The DataFeedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataFeedId;
    /**
     * The MaxRootRecordCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxRootRecordCount;
    /**
     * Constructor method for GetAvailableDataRequest
     * @uses GetAvailableDataRequest::setDataFeedId()
     * @uses GetAvailableDataRequest::setMaxRootRecordCount()
     * @param string $dataFeedId
     * @param int $maxRootRecordCount
     */
    public function __construct($dataFeedId = null, $maxRootRecordCount = null)
    {
        $this
            ->setDataFeedId($dataFeedId)
            ->setMaxRootRecordCount($maxRootRecordCount);
    }
    /**
     * Get DataFeedId value
     * @return string|null
     */
    public function getDataFeedId()
    {
        return $this->DataFeedId;
    }
    /**
     * Set DataFeedId value
     * @param string $dataFeedId
     * @return \patest\StructType\GetAvailableDataRequest
     */
    public function setDataFeedId($dataFeedId = null)
    {
        // validation for constraint: string
        if (!is_null($dataFeedId) && !is_string($dataFeedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFeedId, true), gettype($dataFeedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataFeedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataFeedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataFeedId, true)), __LINE__);
        }
        $this->DataFeedId = $dataFeedId;
        return $this;
    }
    /**
     * Get MaxRootRecordCount value
     * @return int|null
     */
    public function getMaxRootRecordCount()
    {
        return $this->MaxRootRecordCount;
    }
    /**
     * Set MaxRootRecordCount value
     * @param int $maxRootRecordCount
     * @return \patest\StructType\GetAvailableDataRequest
     */
    public function setMaxRootRecordCount($maxRootRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxRootRecordCount) && !(is_int($maxRootRecordCount) || ctype_digit($maxRootRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRootRecordCount, true), gettype($maxRootRecordCount)), __LINE__);
        }
        $this->MaxRootRecordCount = $maxRootRecordCount;
        return $this;
    }
}
