<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableDataProtectionQuestionsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableDataProtectionQuestionsRequest
 * @subpackage Structs
 */
class GetAvailableDataProtectionQuestionsRequest extends AbstractStructBase
{
    /**
     * The CircumventAnswerCaching
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CircumventAnswerCaching;
    /**
     * The ForceForHiddenClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceForHiddenClient;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for GetAvailableDataProtectionQuestionsRequest
     * @uses GetAvailableDataProtectionQuestionsRequest::setCircumventAnswerCaching()
     * @uses GetAvailableDataProtectionQuestionsRequest::setForceForHiddenClient()
     * @uses GetAvailableDataProtectionQuestionsRequest::setTransactionGuid()
     * @param bool $circumventAnswerCaching
     * @param bool $forceForHiddenClient
     * @param string $transactionGuid
     */
    public function __construct($circumventAnswerCaching = null, $forceForHiddenClient = null, $transactionGuid = null)
    {
        $this
            ->setCircumventAnswerCaching($circumventAnswerCaching)
            ->setForceForHiddenClient($forceForHiddenClient)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get CircumventAnswerCaching value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCircumventAnswerCaching()
    {
        return isset($this->CircumventAnswerCaching) ? $this->CircumventAnswerCaching : null;
    }
    /**
     * Set CircumventAnswerCaching value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $circumventAnswerCaching
     * @return \patest\StructType\GetAvailableDataProtectionQuestionsRequest
     */
    public function setCircumventAnswerCaching($circumventAnswerCaching = null)
    {
        // validation for constraint: boolean
        if (!is_null($circumventAnswerCaching) && !is_bool($circumventAnswerCaching)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($circumventAnswerCaching, true), gettype($circumventAnswerCaching)), __LINE__);
        }
        if (is_null($circumventAnswerCaching) || (is_array($circumventAnswerCaching) && empty($circumventAnswerCaching))) {
            unset($this->CircumventAnswerCaching);
        } else {
            $this->CircumventAnswerCaching = $circumventAnswerCaching;
        }
        return $this;
    }
    /**
     * Get ForceForHiddenClient value
     * @return bool|null
     */
    public function getForceForHiddenClient()
    {
        return $this->ForceForHiddenClient;
    }
    /**
     * Set ForceForHiddenClient value
     * @param bool $forceForHiddenClient
     * @return \patest\StructType\GetAvailableDataProtectionQuestionsRequest
     */
    public function setForceForHiddenClient($forceForHiddenClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceForHiddenClient) && !is_bool($forceForHiddenClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceForHiddenClient, true), gettype($forceForHiddenClient)), __LINE__);
        }
        $this->ForceForHiddenClient = $forceForHiddenClient;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\GetAvailableDataProtectionQuestionsRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
