<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateOTP-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GenerateOTP-Request
 * @subpackage Structs
 */
class GenerateOTP_Request extends ExtensibleDataContract
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The AuthenticationMethod
     * @var string
     */
    public $AuthenticationMethod;
    /**
     * The UserIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserIdentifier;
    /**
     * Constructor method for GenerateOTP-Request
     * @uses GenerateOTP_Request::setApplication()
     * @uses GenerateOTP_Request::setAuthenticationMethod()
     * @uses GenerateOTP_Request::setUserIdentifier()
     * @param string $application
     * @param string $authenticationMethod
     * @param string $userIdentifier
     */
    public function __construct($application = null, $authenticationMethod = null, $userIdentifier = null)
    {
        $this
            ->setApplication($application)
            ->setAuthenticationMethod($authenticationMethod)
            ->setUserIdentifier($userIdentifier);
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \patest\StructType\GenerateOTP_Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get AuthenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->AuthenticationMethod;
    }
    /**
     * Set AuthenticationMethod value
     * @uses \patest\EnumType\OTPAuthenticationMethod::valueIsValid()
     * @uses \patest\EnumType\OTPAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return \patest\StructType\GenerateOTP_Request
     */
    public function setAuthenticationMethod($authenticationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OTPAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OTPAuthenticationMethod', is_array($authenticationMethod) ? implode(', ', $authenticationMethod) : var_export($authenticationMethod, true), implode(', ', \patest\EnumType\OTPAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->AuthenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get UserIdentifier value
     * @return string|null
     */
    public function getUserIdentifier()
    {
        return $this->UserIdentifier;
    }
    /**
     * Set UserIdentifier value
     * @param string $userIdentifier
     * @return \patest\StructType\GenerateOTP_Request
     */
    public function setUserIdentifier($userIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($userIdentifier) && !is_string($userIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdentifier, true), gettype($userIdentifier)), __LINE__);
        }
        $this->UserIdentifier = $userIdentifier;
        return $this;
    }
}
