<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateBarcodes-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GenerateBarcodes-Request
 * @subpackage Structs
 */
class GenerateBarcodes_Request extends ExtensibleDataContract
{
    /**
     * The AbortIfAtLeastOneItemIsNonPrintable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AbortIfAtLeastOneItemIsNonPrintable;
    /**
     * The GenerateNewBarcodeIfAlreadyExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateNewBarcodeIfAlreadyExists;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGenerateBarcodeItem
     */
    public $Items;
    /**
     * Constructor method for GenerateBarcodes-Request
     * @uses GenerateBarcodes_Request::setAbortIfAtLeastOneItemIsNonPrintable()
     * @uses GenerateBarcodes_Request::setGenerateNewBarcodeIfAlreadyExists()
     * @uses GenerateBarcodes_Request::setItems()
     * @param bool $abortIfAtLeastOneItemIsNonPrintable
     * @param bool $generateNewBarcodeIfAlreadyExists
     * @param \patest\ArrayType\ArrayOfGenerateBarcodeItem $items
     */
    public function __construct($abortIfAtLeastOneItemIsNonPrintable = null, $generateNewBarcodeIfAlreadyExists = null, \patest\ArrayType\ArrayOfGenerateBarcodeItem $items = null)
    {
        $this
            ->setAbortIfAtLeastOneItemIsNonPrintable($abortIfAtLeastOneItemIsNonPrintable)
            ->setGenerateNewBarcodeIfAlreadyExists($generateNewBarcodeIfAlreadyExists)
            ->setItems($items);
    }
    /**
     * Get AbortIfAtLeastOneItemIsNonPrintable value
     * @return bool|null
     */
    public function getAbortIfAtLeastOneItemIsNonPrintable()
    {
        return $this->AbortIfAtLeastOneItemIsNonPrintable;
    }
    /**
     * Set AbortIfAtLeastOneItemIsNonPrintable value
     * @param bool $abortIfAtLeastOneItemIsNonPrintable
     * @return \patest\StructType\GenerateBarcodes_Request
     */
    public function setAbortIfAtLeastOneItemIsNonPrintable($abortIfAtLeastOneItemIsNonPrintable = null)
    {
        // validation for constraint: boolean
        if (!is_null($abortIfAtLeastOneItemIsNonPrintable) && !is_bool($abortIfAtLeastOneItemIsNonPrintable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abortIfAtLeastOneItemIsNonPrintable, true), gettype($abortIfAtLeastOneItemIsNonPrintable)), __LINE__);
        }
        $this->AbortIfAtLeastOneItemIsNonPrintable = $abortIfAtLeastOneItemIsNonPrintable;
        return $this;
    }
    /**
     * Get GenerateNewBarcodeIfAlreadyExists value
     * @return bool|null
     */
    public function getGenerateNewBarcodeIfAlreadyExists()
    {
        return $this->GenerateNewBarcodeIfAlreadyExists;
    }
    /**
     * Set GenerateNewBarcodeIfAlreadyExists value
     * @param bool $generateNewBarcodeIfAlreadyExists
     * @return \patest\StructType\GenerateBarcodes_Request
     */
    public function setGenerateNewBarcodeIfAlreadyExists($generateNewBarcodeIfAlreadyExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateNewBarcodeIfAlreadyExists) && !is_bool($generateNewBarcodeIfAlreadyExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateNewBarcodeIfAlreadyExists, true), gettype($generateNewBarcodeIfAlreadyExists)), __LINE__);
        }
        $this->GenerateNewBarcodeIfAlreadyExists = $generateNewBarcodeIfAlreadyExists;
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGenerateBarcodeItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGenerateBarcodeItem $items
     * @return \patest\StructType\GenerateBarcodes_Request
     */
    public function setItems(\patest\ArrayType\ArrayOfGenerateBarcodeItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
}
