<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAdmissionRestrictionSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeneralAdmissionRestrictionSettings
 * @subpackage Structs
 */
class GeneralAdmissionRestrictionSettings extends AbstractGeneralAdmissionLayerSettings
{
    /**
     * The AllocatedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AllocatedQuantity;
    /**
     * The IsRelativeQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRelativeQuantity;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $Restrictions;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * Constructor method for GeneralAdmissionRestrictionSettings
     * @uses GeneralAdmissionRestrictionSettings::setAllocatedQuantity()
     * @uses GeneralAdmissionRestrictionSettings::setIsRelativeQuantity()
     * @uses GeneralAdmissionRestrictionSettings::setRestrictions()
     * @uses GeneralAdmissionRestrictionSettings::setGroupId()
     * @param int $allocatedQuantity
     * @param bool $isRelativeQuantity
     * @param \patest\ArrayType\ArrayOfguid $restrictions
     * @param string $groupId
     */
    public function __construct($allocatedQuantity = null, $isRelativeQuantity = null, \patest\ArrayType\ArrayOfguid $restrictions = null, $groupId = null)
    {
        $this
            ->setAllocatedQuantity($allocatedQuantity)
            ->setIsRelativeQuantity($isRelativeQuantity)
            ->setRestrictions($restrictions)
            ->setGroupId($groupId);
    }
    /**
     * Get AllocatedQuantity value
     * @return int|null
     */
    public function getAllocatedQuantity()
    {
        return $this->AllocatedQuantity;
    }
    /**
     * Set AllocatedQuantity value
     * @param int $allocatedQuantity
     * @return \patest\StructType\GeneralAdmissionRestrictionSettings
     */
    public function setAllocatedQuantity($allocatedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedQuantity) && !(is_int($allocatedQuantity) || ctype_digit($allocatedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedQuantity, true), gettype($allocatedQuantity)), __LINE__);
        }
        $this->AllocatedQuantity = $allocatedQuantity;
        return $this;
    }
    /**
     * Get IsRelativeQuantity value
     * @return bool|null
     */
    public function getIsRelativeQuantity()
    {
        return $this->IsRelativeQuantity;
    }
    /**
     * Set IsRelativeQuantity value
     * @param bool $isRelativeQuantity
     * @return \patest\StructType\GeneralAdmissionRestrictionSettings
     */
    public function setIsRelativeQuantity($isRelativeQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelativeQuantity) && !is_bool($isRelativeQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelativeQuantity, true), gettype($isRelativeQuantity)), __LINE__);
        }
        $this->IsRelativeQuantity = $isRelativeQuantity;
        return $this;
    }
    /**
     * Get Restrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRestrictions()
    {
        return isset($this->Restrictions) ? $this->Restrictions : null;
    }
    /**
     * Set Restrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $restrictions
     * @return \patest\StructType\GeneralAdmissionRestrictionSettings
     */
    public function setRestrictions(\patest\ArrayType\ArrayOfguid $restrictions = null)
    {
        if (is_null($restrictions) || (is_array($restrictions) && empty($restrictions))) {
            unset($this->Restrictions);
        } else {
            $this->Restrictions = $restrictions;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\GeneralAdmissionRestrictionSettings
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
}
