<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GSEntry StructType
 * @subpackage Structs
 */
class GSEntry extends AbstractStructBase
{
    /**
     * The LCID
     * @var int
     */
    public $LCID;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for GSEntry
     * @uses GSEntry::setLCID()
     * @uses GSEntry::setText()
     * @param int $lCID
     * @param string $text
     */
    public function __construct($lCID = null, $text = null)
    {
        $this
            ->setLCID($lCID)
            ->setText($text);
    }
    /**
     * Get LCID value
     * @return int|null
     */
    public function getLCID()
    {
        return $this->LCID;
    }
    /**
     * Set LCID value
     * @param int $lCID
     * @return \patest\StructType\GSEntry
     */
    public function setLCID($lCID = null)
    {
        // validation for constraint: int
        if (!is_null($lCID) && !(is_int($lCID) || ctype_digit($lCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lCID, true), gettype($lCID)), __LINE__);
        }
        $this->LCID = $lCID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \patest\StructType\GSEntry
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
}
