<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.ProcessSchedule StructType
 * @subpackage Structs
 */
class Foundation_ProcessSchedule extends AnyEntity
{
    /**
     * The DailyRecurringEndingAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DailyRecurringEndingAt;
    /**
     * The DailyRecurringInterval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DailyRecurringInterval;
    /**
     * The DailyRecurringStartingAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DailyRecurringStartingAt;
    /**
     * The DaysOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaysOfWeek;
    /**
     * The DurationEndingAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationEndingAt;
    /**
     * The DurationStartingAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationStartingAt;
    /**
     * The MonthDayType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MonthDayType;
    /**
     * The MonthlyDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MonthlyDay;
    /**
     * The MonthlyDayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MonthlyDayOfWeek;
    /**
     * The MonthlyWeekOfMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MonthlyWeekOfMonth;
    /**
     * The OccuresEvery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OccuresEvery;
    /**
     * The RecurringFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurringFrequency;
    /**
     * The RunOnceDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunOnceDateTime;
    /**
     * The ScheduleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduleType;
    /**
     * Constructor method for Foundation.ProcessSchedule
     * @uses Foundation_ProcessSchedule::setDailyRecurringEndingAt()
     * @uses Foundation_ProcessSchedule::setDailyRecurringInterval()
     * @uses Foundation_ProcessSchedule::setDailyRecurringStartingAt()
     * @uses Foundation_ProcessSchedule::setDaysOfWeek()
     * @uses Foundation_ProcessSchedule::setDurationEndingAt()
     * @uses Foundation_ProcessSchedule::setDurationStartingAt()
     * @uses Foundation_ProcessSchedule::setMonthDayType()
     * @uses Foundation_ProcessSchedule::setMonthlyDay()
     * @uses Foundation_ProcessSchedule::setMonthlyDayOfWeek()
     * @uses Foundation_ProcessSchedule::setMonthlyWeekOfMonth()
     * @uses Foundation_ProcessSchedule::setOccuresEvery()
     * @uses Foundation_ProcessSchedule::setRecurringFrequency()
     * @uses Foundation_ProcessSchedule::setRunOnceDateTime()
     * @uses Foundation_ProcessSchedule::setScheduleType()
     * @param string $dailyRecurringEndingAt
     * @param float $dailyRecurringInterval
     * @param string $dailyRecurringStartingAt
     * @param string $daysOfWeek
     * @param string $durationEndingAt
     * @param string $durationStartingAt
     * @param string $monthDayType
     * @param int $monthlyDay
     * @param string $monthlyDayOfWeek
     * @param string $monthlyWeekOfMonth
     * @param int $occuresEvery
     * @param string $recurringFrequency
     * @param string $runOnceDateTime
     * @param string $scheduleType
     */
    public function __construct($dailyRecurringEndingAt = null, $dailyRecurringInterval = null, $dailyRecurringStartingAt = null, $daysOfWeek = null, $durationEndingAt = null, $durationStartingAt = null, $monthDayType = null, $monthlyDay = null, $monthlyDayOfWeek = null, $monthlyWeekOfMonth = null, $occuresEvery = null, $recurringFrequency = null, $runOnceDateTime = null, $scheduleType = null)
    {
        $this
            ->setDailyRecurringEndingAt($dailyRecurringEndingAt)
            ->setDailyRecurringInterval($dailyRecurringInterval)
            ->setDailyRecurringStartingAt($dailyRecurringStartingAt)
            ->setDaysOfWeek($daysOfWeek)
            ->setDurationEndingAt($durationEndingAt)
            ->setDurationStartingAt($durationStartingAt)
            ->setMonthDayType($monthDayType)
            ->setMonthlyDay($monthlyDay)
            ->setMonthlyDayOfWeek($monthlyDayOfWeek)
            ->setMonthlyWeekOfMonth($monthlyWeekOfMonth)
            ->setOccuresEvery($occuresEvery)
            ->setRecurringFrequency($recurringFrequency)
            ->setRunOnceDateTime($runOnceDateTime)
            ->setScheduleType($scheduleType);
    }
    /**
     * Get DailyRecurringEndingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDailyRecurringEndingAt()
    {
        return isset($this->DailyRecurringEndingAt) ? $this->DailyRecurringEndingAt : null;
    }
    /**
     * Set DailyRecurringEndingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dailyRecurringEndingAt
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDailyRecurringEndingAt($dailyRecurringEndingAt = null)
    {
        // validation for constraint: string
        if (!is_null($dailyRecurringEndingAt) && !is_string($dailyRecurringEndingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dailyRecurringEndingAt, true), gettype($dailyRecurringEndingAt)), __LINE__);
        }
        if (is_null($dailyRecurringEndingAt) || (is_array($dailyRecurringEndingAt) && empty($dailyRecurringEndingAt))) {
            unset($this->DailyRecurringEndingAt);
        } else {
            $this->DailyRecurringEndingAt = $dailyRecurringEndingAt;
        }
        return $this;
    }
    /**
     * Get DailyRecurringInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDailyRecurringInterval()
    {
        return isset($this->DailyRecurringInterval) ? $this->DailyRecurringInterval : null;
    }
    /**
     * Set DailyRecurringInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dailyRecurringInterval
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDailyRecurringInterval($dailyRecurringInterval = null)
    {
        // validation for constraint: float
        if (!is_null($dailyRecurringInterval) && !(is_float($dailyRecurringInterval) || is_numeric($dailyRecurringInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyRecurringInterval, true), gettype($dailyRecurringInterval)), __LINE__);
        }
        if (is_null($dailyRecurringInterval) || (is_array($dailyRecurringInterval) && empty($dailyRecurringInterval))) {
            unset($this->DailyRecurringInterval);
        } else {
            $this->DailyRecurringInterval = $dailyRecurringInterval;
        }
        return $this;
    }
    /**
     * Get DailyRecurringStartingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDailyRecurringStartingAt()
    {
        return isset($this->DailyRecurringStartingAt) ? $this->DailyRecurringStartingAt : null;
    }
    /**
     * Set DailyRecurringStartingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dailyRecurringStartingAt
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDailyRecurringStartingAt($dailyRecurringStartingAt = null)
    {
        // validation for constraint: string
        if (!is_null($dailyRecurringStartingAt) && !is_string($dailyRecurringStartingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dailyRecurringStartingAt, true), gettype($dailyRecurringStartingAt)), __LINE__);
        }
        if (is_null($dailyRecurringStartingAt) || (is_array($dailyRecurringStartingAt) && empty($dailyRecurringStartingAt))) {
            unset($this->DailyRecurringStartingAt);
        } else {
            $this->DailyRecurringStartingAt = $dailyRecurringStartingAt;
        }
        return $this;
    }
    /**
     * Get DaysOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaysOfWeek()
    {
        return isset($this->DaysOfWeek) ? $this->DaysOfWeek : null;
    }
    /**
     * Set DaysOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daysOfWeek
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDaysOfWeek($daysOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($daysOfWeek) && !is_string($daysOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysOfWeek, true), gettype($daysOfWeek)), __LINE__);
        }
        if (is_null($daysOfWeek) || (is_array($daysOfWeek) && empty($daysOfWeek))) {
            unset($this->DaysOfWeek);
        } else {
            $this->DaysOfWeek = $daysOfWeek;
        }
        return $this;
    }
    /**
     * Get DurationEndingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationEndingAt()
    {
        return isset($this->DurationEndingAt) ? $this->DurationEndingAt : null;
    }
    /**
     * Set DurationEndingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durationEndingAt
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDurationEndingAt($durationEndingAt = null)
    {
        // validation for constraint: string
        if (!is_null($durationEndingAt) && !is_string($durationEndingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationEndingAt, true), gettype($durationEndingAt)), __LINE__);
        }
        if (is_null($durationEndingAt) || (is_array($durationEndingAt) && empty($durationEndingAt))) {
            unset($this->DurationEndingAt);
        } else {
            $this->DurationEndingAt = $durationEndingAt;
        }
        return $this;
    }
    /**
     * Get DurationStartingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationStartingAt()
    {
        return isset($this->DurationStartingAt) ? $this->DurationStartingAt : null;
    }
    /**
     * Set DurationStartingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durationStartingAt
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setDurationStartingAt($durationStartingAt = null)
    {
        // validation for constraint: string
        if (!is_null($durationStartingAt) && !is_string($durationStartingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationStartingAt, true), gettype($durationStartingAt)), __LINE__);
        }
        if (is_null($durationStartingAt) || (is_array($durationStartingAt) && empty($durationStartingAt))) {
            unset($this->DurationStartingAt);
        } else {
            $this->DurationStartingAt = $durationStartingAt;
        }
        return $this;
    }
    /**
     * Get MonthDayType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMonthDayType()
    {
        return isset($this->MonthDayType) ? $this->MonthDayType : null;
    }
    /**
     * Set MonthDayType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MonthDayType::valueIsValid()
     * @uses \patest\EnumType\MonthDayType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthDayType
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setMonthDayType($monthDayType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MonthDayType::valueIsValid($monthDayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MonthDayType', is_array($monthDayType) ? implode(', ', $monthDayType) : var_export($monthDayType, true), implode(', ', \patest\EnumType\MonthDayType::getValidValues())), __LINE__);
        }
        if (is_null($monthDayType) || (is_array($monthDayType) && empty($monthDayType))) {
            unset($this->MonthDayType);
        } else {
            $this->MonthDayType = $monthDayType;
        }
        return $this;
    }
    /**
     * Get MonthlyDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMonthlyDay()
    {
        return isset($this->MonthlyDay) ? $this->MonthlyDay : null;
    }
    /**
     * Set MonthlyDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $monthlyDay
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setMonthlyDay($monthlyDay = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyDay) && !(is_int($monthlyDay) || ctype_digit($monthlyDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthlyDay, true), gettype($monthlyDay)), __LINE__);
        }
        if (is_null($monthlyDay) || (is_array($monthlyDay) && empty($monthlyDay))) {
            unset($this->MonthlyDay);
        } else {
            $this->MonthlyDay = $monthlyDay;
        }
        return $this;
    }
    /**
     * Get MonthlyDayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMonthlyDayOfWeek()
    {
        return isset($this->MonthlyDayOfWeek) ? $this->MonthlyDayOfWeek : null;
    }
    /**
     * Set MonthlyDayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DayOfWeek::valueIsValid()
     * @uses \patest\EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthlyDayOfWeek
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setMonthlyDayOfWeek($monthlyDayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DayOfWeek::valueIsValid($monthlyDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DayOfWeek', is_array($monthlyDayOfWeek) ? implode(', ', $monthlyDayOfWeek) : var_export($monthlyDayOfWeek, true), implode(', ', \patest\EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        if (is_null($monthlyDayOfWeek) || (is_array($monthlyDayOfWeek) && empty($monthlyDayOfWeek))) {
            unset($this->MonthlyDayOfWeek);
        } else {
            $this->MonthlyDayOfWeek = $monthlyDayOfWeek;
        }
        return $this;
    }
    /**
     * Get MonthlyWeekOfMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMonthlyWeekOfMonth()
    {
        return isset($this->MonthlyWeekOfMonth) ? $this->MonthlyWeekOfMonth : null;
    }
    /**
     * Set MonthlyWeekOfMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WeekOfMonth::valueIsValid()
     * @uses \patest\EnumType\WeekOfMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthlyWeekOfMonth
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setMonthlyWeekOfMonth($monthlyWeekOfMonth = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WeekOfMonth::valueIsValid($monthlyWeekOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WeekOfMonth', is_array($monthlyWeekOfMonth) ? implode(', ', $monthlyWeekOfMonth) : var_export($monthlyWeekOfMonth, true), implode(', ', \patest\EnumType\WeekOfMonth::getValidValues())), __LINE__);
        }
        if (is_null($monthlyWeekOfMonth) || (is_array($monthlyWeekOfMonth) && empty($monthlyWeekOfMonth))) {
            unset($this->MonthlyWeekOfMonth);
        } else {
            $this->MonthlyWeekOfMonth = $monthlyWeekOfMonth;
        }
        return $this;
    }
    /**
     * Get OccuresEvery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOccuresEvery()
    {
        return isset($this->OccuresEvery) ? $this->OccuresEvery : null;
    }
    /**
     * Set OccuresEvery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $occuresEvery
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setOccuresEvery($occuresEvery = null)
    {
        // validation for constraint: int
        if (!is_null($occuresEvery) && !(is_int($occuresEvery) || ctype_digit($occuresEvery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occuresEvery, true), gettype($occuresEvery)), __LINE__);
        }
        if (is_null($occuresEvery) || (is_array($occuresEvery) && empty($occuresEvery))) {
            unset($this->OccuresEvery);
        } else {
            $this->OccuresEvery = $occuresEvery;
        }
        return $this;
    }
    /**
     * Get RecurringFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurringFrequency()
    {
        return isset($this->RecurringFrequency) ? $this->RecurringFrequency : null;
    }
    /**
     * Set RecurringFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RecurringFrequency::valueIsValid()
     * @uses \patest\EnumType\RecurringFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurringFrequency
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setRecurringFrequency($recurringFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RecurringFrequency::valueIsValid($recurringFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RecurringFrequency', is_array($recurringFrequency) ? implode(', ', $recurringFrequency) : var_export($recurringFrequency, true), implode(', ', \patest\EnumType\RecurringFrequency::getValidValues())), __LINE__);
        }
        if (is_null($recurringFrequency) || (is_array($recurringFrequency) && empty($recurringFrequency))) {
            unset($this->RecurringFrequency);
        } else {
            $this->RecurringFrequency = $recurringFrequency;
        }
        return $this;
    }
    /**
     * Get RunOnceDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunOnceDateTime()
    {
        return isset($this->RunOnceDateTime) ? $this->RunOnceDateTime : null;
    }
    /**
     * Set RunOnceDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runOnceDateTime
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setRunOnceDateTime($runOnceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($runOnceDateTime) && !is_string($runOnceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runOnceDateTime, true), gettype($runOnceDateTime)), __LINE__);
        }
        if (is_null($runOnceDateTime) || (is_array($runOnceDateTime) && empty($runOnceDateTime))) {
            unset($this->RunOnceDateTime);
        } else {
            $this->RunOnceDateTime = $runOnceDateTime;
        }
        return $this;
    }
    /**
     * Get ScheduleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduleType()
    {
        return isset($this->ScheduleType) ? $this->ScheduleType : null;
    }
    /**
     * Set ScheduleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScheduleType::valueIsValid()
     * @uses \patest\EnumType\ScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleType
     * @return \patest\StructType\Foundation_ProcessSchedule
     */
    public function setScheduleType($scheduleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScheduleType::valueIsValid($scheduleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScheduleType', is_array($scheduleType) ? implode(', ', $scheduleType) : var_export($scheduleType, true), implode(', ', \patest\EnumType\ScheduleType::getValidValues())), __LINE__);
        }
        if (is_null($scheduleType) || (is_array($scheduleType) && empty($scheduleType))) {
            unset($this->ScheduleType);
        } else {
            $this->ScheduleType = $scheduleType;
        }
        return $this;
    }
}
