<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.ProcessJournalEntry StructType
 * @subpackage Structs
 */
class Foundation_ProcessJournalEntry extends Foundation_JournalEntry
{
    /**
     * The ItemContentsXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemContentsXml;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemState;
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The ProcessInstanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessInstanceId;
    /**
     * The ProcessNodeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessNodeName;
    /**
     * The ProcessState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessState;
    /**
     * Constructor method for Foundation.ProcessJournalEntry
     * @uses Foundation_ProcessJournalEntry::setItemContentsXml()
     * @uses Foundation_ProcessJournalEntry::setItemDescription()
     * @uses Foundation_ProcessJournalEntry::setItemId()
     * @uses Foundation_ProcessJournalEntry::setItemState()
     * @uses Foundation_ProcessJournalEntry::setProcessDefinitionId()
     * @uses Foundation_ProcessJournalEntry::setProcessInstanceId()
     * @uses Foundation_ProcessJournalEntry::setProcessNodeName()
     * @uses Foundation_ProcessJournalEntry::setProcessState()
     * @param string $itemContentsXml
     * @param string $itemDescription
     * @param string $itemId
     * @param string $itemState
     * @param string $processDefinitionId
     * @param int $processInstanceId
     * @param string $processNodeName
     * @param string $processState
     */
    public function __construct($itemContentsXml = null, $itemDescription = null, $itemId = null, $itemState = null, $processDefinitionId = null, $processInstanceId = null, $processNodeName = null, $processState = null)
    {
        $this
            ->setItemContentsXml($itemContentsXml)
            ->setItemDescription($itemDescription)
            ->setItemId($itemId)
            ->setItemState($itemState)
            ->setProcessDefinitionId($processDefinitionId)
            ->setProcessInstanceId($processInstanceId)
            ->setProcessNodeName($processNodeName)
            ->setProcessState($processState);
    }
    /**
     * Get ItemContentsXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemContentsXml()
    {
        return isset($this->ItemContentsXml) ? $this->ItemContentsXml : null;
    }
    /**
     * Set ItemContentsXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemContentsXml
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setItemContentsXml($itemContentsXml = null)
    {
        // validation for constraint: string
        if (!is_null($itemContentsXml) && !is_string($itemContentsXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemContentsXml, true), gettype($itemContentsXml)), __LINE__);
        }
        if (is_null($itemContentsXml) || (is_array($itemContentsXml) && empty($itemContentsXml))) {
            unset($this->ItemContentsXml);
        } else {
            $this->ItemContentsXml = $itemContentsXml;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemState()
    {
        return isset($this->ItemState) ? $this->ItemState : null;
    }
    /**
     * Set ItemState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\QueuedWorkItemState::valueIsValid()
     * @uses \patest\EnumType\QueuedWorkItemState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemState
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setItemState($itemState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\QueuedWorkItemState::valueIsValid($itemState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\QueuedWorkItemState', is_array($itemState) ? implode(', ', $itemState) : var_export($itemState, true), implode(', ', \patest\EnumType\QueuedWorkItemState::getValidValues())), __LINE__);
        }
        if (is_null($itemState) || (is_array($itemState) && empty($itemState))) {
            unset($this->ItemState);
        } else {
            $this->ItemState = $itemState;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get ProcessInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessInstanceId()
    {
        return isset($this->ProcessInstanceId) ? $this->ProcessInstanceId : null;
    }
    /**
     * Set ProcessInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processInstanceId
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setProcessInstanceId($processInstanceId = null)
    {
        // validation for constraint: int
        if (!is_null($processInstanceId) && !(is_int($processInstanceId) || ctype_digit($processInstanceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processInstanceId, true), gettype($processInstanceId)), __LINE__);
        }
        if (is_null($processInstanceId) || (is_array($processInstanceId) && empty($processInstanceId))) {
            unset($this->ProcessInstanceId);
        } else {
            $this->ProcessInstanceId = $processInstanceId;
        }
        return $this;
    }
    /**
     * Get ProcessNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessNodeName()
    {
        return isset($this->ProcessNodeName) ? $this->ProcessNodeName : null;
    }
    /**
     * Set ProcessNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processNodeName
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setProcessNodeName($processNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($processNodeName) && !is_string($processNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processNodeName, true), gettype($processNodeName)), __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->ProcessNodeName);
        } else {
            $this->ProcessNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get ProcessState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessState()
    {
        return isset($this->ProcessState) ? $this->ProcessState : null;
    }
    /**
     * Set ProcessState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProcessInstanceState::valueIsValid()
     * @uses \patest\EnumType\ProcessInstanceState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processState
     * @return \patest\StructType\Foundation_ProcessJournalEntry
     */
    public function setProcessState($processState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProcessInstanceState::valueIsValid($processState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProcessInstanceState', is_array($processState) ? implode(', ', $processState) : var_export($processState, true), implode(', ', \patest\EnumType\ProcessInstanceState::getValidValues())), __LINE__);
        }
        if (is_null($processState) || (is_array($processState) && empty($processState))) {
            unset($this->ProcessState);
        } else {
            $this->ProcessState = $processState;
        }
        return $this;
    }
}
