<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.EtlRunsFilter StructType
 * @subpackage Structs
 */
class Foundation_EtlRunsFilter extends FilterEntity
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsDisplayAll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDisplayAll;
    /**
     * The RunType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunType;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Foundation.EtlRunsFilter
     * @uses Foundation_EtlRunsFilter::setFromDate()
     * @uses Foundation_EtlRunsFilter::setIsDisplayAll()
     * @uses Foundation_EtlRunsFilter::setRunType()
     * @uses Foundation_EtlRunsFilter::setToDate()
     * @param string $fromDate
     * @param bool $isDisplayAll
     * @param string $runType
     * @param string $toDate
     */
    public function __construct($fromDate = null, $isDisplayAll = null, $runType = null, $toDate = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setIsDisplayAll($isDisplayAll)
            ->setRunType($runType)
            ->setToDate($toDate);
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Foundation_EtlRunsFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsDisplayAll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDisplayAll()
    {
        return isset($this->IsDisplayAll) ? $this->IsDisplayAll : null;
    }
    /**
     * Set IsDisplayAll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDisplayAll
     * @return \patest\StructType\Foundation_EtlRunsFilter
     */
    public function setIsDisplayAll($isDisplayAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDisplayAll) && !is_bool($isDisplayAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisplayAll, true), gettype($isDisplayAll)), __LINE__);
        }
        if (is_null($isDisplayAll) || (is_array($isDisplayAll) && empty($isDisplayAll))) {
            unset($this->IsDisplayAll);
        } else {
            $this->IsDisplayAll = $isDisplayAll;
        }
        return $this;
    }
    /**
     * Get RunType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunType()
    {
        return isset($this->RunType) ? $this->RunType : null;
    }
    /**
     * Set RunType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EtlProcessRunKind::valueIsValid()
     * @uses \patest\EnumType\EtlProcessRunKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $runType
     * @return \patest\StructType\Foundation_EtlRunsFilter
     */
    public function setRunType($runType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EtlProcessRunKind::valueIsValid($runType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EtlProcessRunKind', is_array($runType) ? implode(', ', $runType) : var_export($runType, true), implode(', ', \patest\EnumType\EtlProcessRunKind::getValidValues())), __LINE__);
        }
        if (is_null($runType) || (is_array($runType) && empty($runType))) {
            unset($this->RunType);
        } else {
            $this->RunType = $runType;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Foundation_EtlRunsFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
