<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.BulkOperationsProcessingJobData StructType
 * @subpackage Structs
 */
class Foundation_BulkOperationsProcessingJobData extends AnyEntity
{
    /**
     * The BulkOperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BulkOperationId;
    /**
     * Constructor method for Foundation.BulkOperationsProcessingJobData
     * @uses Foundation_BulkOperationsProcessingJobData::setBulkOperationId()
     * @param string $bulkOperationId
     */
    public function __construct($bulkOperationId = null)
    {
        $this
            ->setBulkOperationId($bulkOperationId);
    }
    /**
     * Get BulkOperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulkOperationId()
    {
        return isset($this->BulkOperationId) ? $this->BulkOperationId : null;
    }
    /**
     * Set BulkOperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulkOperationId
     * @return \patest\StructType\Foundation_BulkOperationsProcessingJobData
     */
    public function setBulkOperationId($bulkOperationId = null)
    {
        // validation for constraint: string
        if (!is_null($bulkOperationId) && !is_string($bulkOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkOperationId, true), gettype($bulkOperationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bulkOperationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bulkOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bulkOperationId, true)), __LINE__);
        }
        if (is_null($bulkOperationId) || (is_array($bulkOperationId) && empty($bulkOperationId))) {
            unset($this->BulkOperationId);
        } else {
            $this->BulkOperationId = $bulkOperationId;
        }
        return $this;
    }
}
