<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlushDumpRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlushDumpRequest
 * @subpackage Structs
 */
class FlushDumpRequest extends AbstractStructBase
{
    /**
     * The CDBDirectory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDBDirectory;
    /**
     * The DumpFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DumpFileName;
    /**
     * The IsForceGC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsForceGC;
    /**
     * Constructor method for FlushDumpRequest
     * @uses FlushDumpRequest::setCDBDirectory()
     * @uses FlushDumpRequest::setDumpFileName()
     * @uses FlushDumpRequest::setIsForceGC()
     * @param string $cDBDirectory
     * @param string $dumpFileName
     * @param bool $isForceGC
     */
    public function __construct($cDBDirectory = null, $dumpFileName = null, $isForceGC = null)
    {
        $this
            ->setCDBDirectory($cDBDirectory)
            ->setDumpFileName($dumpFileName)
            ->setIsForceGC($isForceGC);
    }
    /**
     * Get CDBDirectory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDBDirectory()
    {
        return isset($this->CDBDirectory) ? $this->CDBDirectory : null;
    }
    /**
     * Set CDBDirectory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDBDirectory
     * @return \patest\StructType\FlushDumpRequest
     */
    public function setCDBDirectory($cDBDirectory = null)
    {
        // validation for constraint: string
        if (!is_null($cDBDirectory) && !is_string($cDBDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cDBDirectory, true), gettype($cDBDirectory)), __LINE__);
        }
        if (is_null($cDBDirectory) || (is_array($cDBDirectory) && empty($cDBDirectory))) {
            unset($this->CDBDirectory);
        } else {
            $this->CDBDirectory = $cDBDirectory;
        }
        return $this;
    }
    /**
     * Get DumpFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDumpFileName()
    {
        return isset($this->DumpFileName) ? $this->DumpFileName : null;
    }
    /**
     * Set DumpFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dumpFileName
     * @return \patest\StructType\FlushDumpRequest
     */
    public function setDumpFileName($dumpFileName = null)
    {
        // validation for constraint: string
        if (!is_null($dumpFileName) && !is_string($dumpFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dumpFileName, true), gettype($dumpFileName)), __LINE__);
        }
        if (is_null($dumpFileName) || (is_array($dumpFileName) && empty($dumpFileName))) {
            unset($this->DumpFileName);
        } else {
            $this->DumpFileName = $dumpFileName;
        }
        return $this;
    }
    /**
     * Get IsForceGC value
     * @return bool|null
     */
    public function getIsForceGC()
    {
        return $this->IsForceGC;
    }
    /**
     * Set IsForceGC value
     * @param bool $isForceGC
     * @return \patest\StructType\FlushDumpRequest
     */
    public function setIsForceGC($isForceGC = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForceGC) && !is_bool($isForceGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForceGC, true), gettype($isForceGC)), __LINE__);
        }
        $this->IsForceGC = $isForceGC;
        return $this;
    }
}
