<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtraPromptElementAvailableProductsEventItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExtraPromptElementAvailableProductsEventItem
 * @subpackage Structs
 */
class ExtraPromptElementAvailableProductsEventItem extends ExtraPromptElementAvailableProductsItem
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsSoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSoldOut;
    /**
     * The OccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OccupancyStatus;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * Constructor method for ExtraPromptElementAvailableProductsEventItem
     * @uses ExtraPromptElementAvailableProductsEventItem::setDate()
     * @uses ExtraPromptElementAvailableProductsEventItem::setFormattedDate()
     * @uses ExtraPromptElementAvailableProductsEventItem::setHallName()
     * @uses ExtraPromptElementAvailableProductsEventItem::setIsAvailableForSale()
     * @uses ExtraPromptElementAvailableProductsEventItem::setIsSoldOut()
     * @uses ExtraPromptElementAvailableProductsEventItem::setOccupancyStatus()
     * @uses ExtraPromptElementAvailableProductsEventItem::setShowId()
     * @uses ExtraPromptElementAvailableProductsEventItem::setAreaName()
     * @param string $date
     * @param string $formattedDate
     * @param string $hallName
     * @param bool $isAvailableForSale
     * @param bool $isSoldOut
     * @param string $occupancyStatus
     * @param string $showId
     * @param string $areaName
     */
    public function __construct($date = null, $formattedDate = null, $hallName = null, $isAvailableForSale = null, $isSoldOut = null, $occupancyStatus = null, $showId = null, $areaName = null)
    {
        $this
            ->setDate($date)
            ->setFormattedDate($formattedDate)
            ->setHallName($hallName)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsSoldOut($isSoldOut)
            ->setOccupancyStatus($occupancyStatus)
            ->setShowId($showId)
            ->setAreaName($areaName);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return $this->IsAvailableForSale;
    }
    /**
     * Set IsAvailableForSale value
     * @param bool $isAvailableForSale
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        $this->IsAvailableForSale = $isAvailableForSale;
        return $this;
    }
    /**
     * Get IsSoldOut value
     * @return bool|null
     */
    public function getIsSoldOut()
    {
        return $this->IsSoldOut;
    }
    /**
     * Set IsSoldOut value
     * @param bool $isSoldOut
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setIsSoldOut($isSoldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSoldOut) && !is_bool($isSoldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSoldOut, true), gettype($isSoldOut)), __LINE__);
        }
        $this->IsSoldOut = $isSoldOut;
        return $this;
    }
    /**
     * Get OccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupancyStatus()
    {
        return isset($this->OccupancyStatus) ? $this->OccupancyStatus : null;
    }
    /**
     * Set OccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyStatus
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setOccupancyStatus($occupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($occupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($occupancyStatus) ? implode(', ', $occupancyStatus) : var_export($occupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($occupancyStatus) || (is_array($occupancyStatus) && empty($occupancyStatus))) {
            unset($this->OccupancyStatus);
        } else {
            $this->OccupancyStatus = $occupancyStatus;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\ExtraPromptElementAvailableProductsEventItem
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
}
