<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteBizActionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExecuteBizActionRequest
 * @subpackage Structs
 */
class ExecuteBizActionRequest extends ExtensibleDataContract
{
    /**
     * The BizActionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BizActionName;
    /**
     * The InputParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\InputParameters
     */
    public $InputParameters;
    /**
     * The RequestData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedBizActionData
     */
    public $RequestData;
    /**
     * Constructor method for ExecuteBizActionRequest
     * @uses ExecuteBizActionRequest::setBizActionName()
     * @uses ExecuteBizActionRequest::setInputParameters()
     * @uses ExecuteBizActionRequest::setRequestData()
     * @param string $bizActionName
     * @param \patest\StructType\InputParameters $inputParameters
     * @param \patest\StructType\SerializedBizActionData $requestData
     */
    public function __construct($bizActionName = null, \patest\StructType\InputParameters $inputParameters = null, \patest\StructType\SerializedBizActionData $requestData = null)
    {
        $this
            ->setBizActionName($bizActionName)
            ->setInputParameters($inputParameters)
            ->setRequestData($requestData);
    }
    /**
     * Get BizActionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBizActionName()
    {
        return isset($this->BizActionName) ? $this->BizActionName : null;
    }
    /**
     * Set BizActionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bizActionName
     * @return \patest\StructType\ExecuteBizActionRequest
     */
    public function setBizActionName($bizActionName = null)
    {
        // validation for constraint: string
        if (!is_null($bizActionName) && !is_string($bizActionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bizActionName, true), gettype($bizActionName)), __LINE__);
        }
        if (is_null($bizActionName) || (is_array($bizActionName) && empty($bizActionName))) {
            unset($this->BizActionName);
        } else {
            $this->BizActionName = $bizActionName;
        }
        return $this;
    }
    /**
     * Get InputParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\InputParameters|null
     */
    public function getInputParameters()
    {
        return isset($this->InputParameters) ? $this->InputParameters : null;
    }
    /**
     * Set InputParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\InputParameters $inputParameters
     * @return \patest\StructType\ExecuteBizActionRequest
     */
    public function setInputParameters(\patest\StructType\InputParameters $inputParameters = null)
    {
        if (is_null($inputParameters) || (is_array($inputParameters) && empty($inputParameters))) {
            unset($this->InputParameters);
        } else {
            $this->InputParameters = $inputParameters;
        }
        return $this;
    }
    /**
     * Get RequestData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedBizActionData|null
     */
    public function getRequestData()
    {
        return isset($this->RequestData) ? $this->RequestData : null;
    }
    /**
     * Set RequestData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedBizActionData $requestData
     * @return \patest\StructType\ExecuteBizActionRequest
     */
    public function setRequestData(\patest\StructType\SerializedBizActionData $requestData = null)
    {
        if (is_null($requestData) || (is_array($requestData) && empty($requestData))) {
            unset($this->RequestData);
        } else {
            $this->RequestData = $requestData;
        }
        return $this;
    }
}
