<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeAmounts-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExchangeAmounts-Request
 * @subpackage Structs
 */
class ExchangeAmounts_Request extends ExtensibleDataContract
{
    /**
     * The AmountsToExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr
     */
    public $AmountsToExchange;
    /**
     * The TargetCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for ExchangeAmounts-Request
     * @uses ExchangeAmounts_Request::setAmountsToExchange()
     * @uses ExchangeAmounts_Request::setTargetCurrencyCode()
     * @uses ExchangeAmounts_Request::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr $amountsToExchange
     * @param string $targetCurrencyCode
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr $amountsToExchange = null, $targetCurrencyCode = null, $transactionGuid = null)
    {
        $this
            ->setAmountsToExchange($amountsToExchange)
            ->setTargetCurrencyCode($targetCurrencyCode)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AmountsToExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr|null
     */
    public function getAmountsToExchange()
    {
        return isset($this->AmountsToExchange) ? $this->AmountsToExchange : null;
    }
    /**
     * Set AmountsToExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr $amountsToExchange
     * @return \patest\StructType\ExchangeAmounts_Request
     */
    public function setAmountsToExchange(\patest\ArrayType\ArrayOfKeyValueOfstringMoneyWTEG5wMr $amountsToExchange = null)
    {
        if (is_null($amountsToExchange) || (is_array($amountsToExchange) && empty($amountsToExchange))) {
            unset($this->AmountsToExchange);
        } else {
            $this->AmountsToExchange = $amountsToExchange;
        }
        return $this;
    }
    /**
     * Get TargetCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetCurrencyCode()
    {
        return isset($this->TargetCurrencyCode) ? $this->TargetCurrencyCode : null;
    }
    /**
     * Set TargetCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetCurrencyCode
     * @return \patest\StructType\ExchangeAmounts_Request
     */
    public function setTargetCurrencyCode($targetCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($targetCurrencyCode) && !is_string($targetCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetCurrencyCode, true), gettype($targetCurrencyCode)), __LINE__);
        }
        if (is_null($targetCurrencyCode) || (is_array($targetCurrencyCode) && empty($targetCurrencyCode))) {
            unset($this->TargetCurrencyCode);
        } else {
            $this->TargetCurrencyCode = $targetCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\ExchangeAmounts_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
