<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventTicketsSeatType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventTicketsSeatType
 * @subpackage Structs
 */
class EventTicketsSeatType extends AbstractStructBase
{
    /**
     * The CssClassForOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CssClassForOnline;
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventTicketsGraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The IsAccessible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAccessible;
    /**
     * The IsInfillSeating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInfillSeating;
    /**
     * The IsObstructedView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsObstructedView;
    /**
     * The IsStandingRoomOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsStandingRoomOnly;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for EventTicketsSeatType
     * @uses EventTicketsSeatType::setCssClassForOnline()
     * @uses EventTicketsSeatType::setGraphicRepresentation()
     * @uses EventTicketsSeatType::setIsAccessible()
     * @uses EventTicketsSeatType::setIsInfillSeating()
     * @uses EventTicketsSeatType::setIsObstructedView()
     * @uses EventTicketsSeatType::setIsStandingRoomOnly()
     * @uses EventTicketsSeatType::setName()
     * @uses EventTicketsSeatType::setNote()
     * @uses EventTicketsSeatType::setOrganizationUnitId()
     * @uses EventTicketsSeatType::setVisibleBySubordinates()
     * @param string $cssClassForOnline
     * @param \patest\StructType\EventTicketsGraphicRepresentation $graphicRepresentation
     * @param bool $isAccessible
     * @param bool $isInfillSeating
     * @param bool $isObstructedView
     * @param bool $isStandingRoomOnly
     * @param string $name
     * @param string $note
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($cssClassForOnline = null, \patest\StructType\EventTicketsGraphicRepresentation $graphicRepresentation = null, $isAccessible = null, $isInfillSeating = null, $isObstructedView = null, $isStandingRoomOnly = null, $name = null, $note = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setCssClassForOnline($cssClassForOnline)
            ->setGraphicRepresentation($graphicRepresentation)
            ->setIsAccessible($isAccessible)
            ->setIsInfillSeating($isInfillSeating)
            ->setIsObstructedView($isObstructedView)
            ->setIsStandingRoomOnly($isStandingRoomOnly)
            ->setName($name)
            ->setNote($note)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CssClassForOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCssClassForOnline()
    {
        return isset($this->CssClassForOnline) ? $this->CssClassForOnline : null;
    }
    /**
     * Set CssClassForOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cssClassForOnline
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setCssClassForOnline($cssClassForOnline = null)
    {
        // validation for constraint: string
        if (!is_null($cssClassForOnline) && !is_string($cssClassForOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cssClassForOnline, true), gettype($cssClassForOnline)), __LINE__);
        }
        if (is_null($cssClassForOnline) || (is_array($cssClassForOnline) && empty($cssClassForOnline))) {
            unset($this->CssClassForOnline);
        } else {
            $this->CssClassForOnline = $cssClassForOnline;
        }
        return $this;
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventTicketsGraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventTicketsGraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setGraphicRepresentation(\patest\StructType\EventTicketsGraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get IsAccessible value
     * @return bool|null
     */
    public function getIsAccessible()
    {
        return $this->IsAccessible;
    }
    /**
     * Set IsAccessible value
     * @param bool $isAccessible
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setIsAccessible($isAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessible) && !is_bool($isAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessible, true), gettype($isAccessible)), __LINE__);
        }
        $this->IsAccessible = $isAccessible;
        return $this;
    }
    /**
     * Get IsInfillSeating value
     * @return bool|null
     */
    public function getIsInfillSeating()
    {
        return $this->IsInfillSeating;
    }
    /**
     * Set IsInfillSeating value
     * @param bool $isInfillSeating
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setIsInfillSeating($isInfillSeating = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInfillSeating) && !is_bool($isInfillSeating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInfillSeating, true), gettype($isInfillSeating)), __LINE__);
        }
        $this->IsInfillSeating = $isInfillSeating;
        return $this;
    }
    /**
     * Get IsObstructedView value
     * @return bool|null
     */
    public function getIsObstructedView()
    {
        return $this->IsObstructedView;
    }
    /**
     * Set IsObstructedView value
     * @param bool $isObstructedView
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setIsObstructedView($isObstructedView = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObstructedView) && !is_bool($isObstructedView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObstructedView, true), gettype($isObstructedView)), __LINE__);
        }
        $this->IsObstructedView = $isObstructedView;
        return $this;
    }
    /**
     * Get IsStandingRoomOnly value
     * @return bool|null
     */
    public function getIsStandingRoomOnly()
    {
        return $this->IsStandingRoomOnly;
    }
    /**
     * Set IsStandingRoomOnly value
     * @param bool $isStandingRoomOnly
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setIsStandingRoomOnly($isStandingRoomOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStandingRoomOnly) && !is_bool($isStandingRoomOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStandingRoomOnly, true), gettype($isStandingRoomOnly)), __LINE__);
        }
        $this->IsStandingRoomOnly = $isStandingRoomOnly;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return $this->OrganizationUnitId;
    }
    /**
     * Set OrganizationUnitId value
     * @param string $organizationUnitId
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        $this->OrganizationUnitId = $organizationUnitId;
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return $this->VisibleBySubordinates;
    }
    /**
     * Set VisibleBySubordinates value
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\EventTicketsSeatType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        $this->VisibleBySubordinates = $visibleBySubordinates;
        return $this;
    }
}
