<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EtlRunSummary StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EtlRunSummary
 * @subpackage Structs
 */
class EtlRunSummary extends AbstractStructBase
{
    /**
     * The CompletionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionCode;
    /**
     * The ErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorText;
    /**
     * The ExtractDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExtractDurationMs;
    /**
     * The ExtractedRowCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExtractedRowCount;
    /**
     * The IsRunning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRunning;
    /**
     * The LoadDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoadDurationMs;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The RunEndDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RunEndDateTimeUtc;
    /**
     * The RunKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunKind;
    /**
     * The RunKindText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunKindText;
    /**
     * The RunStartDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RunStartDateTimeUtc;
    /**
     * The StatusText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusText;
    /**
     * The TotalDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalDurationMs;
    /**
     * Constructor method for EtlRunSummary
     * @uses EtlRunSummary::setCompletionCode()
     * @uses EtlRunSummary::setErrorText()
     * @uses EtlRunSummary::setExtractDurationMs()
     * @uses EtlRunSummary::setExtractedRowCount()
     * @uses EtlRunSummary::setIsRunning()
     * @uses EtlRunSummary::setLoadDurationMs()
     * @uses EtlRunSummary::setLocalId()
     * @uses EtlRunSummary::setRunEndDateTimeUtc()
     * @uses EtlRunSummary::setRunKind()
     * @uses EtlRunSummary::setRunKindText()
     * @uses EtlRunSummary::setRunStartDateTimeUtc()
     * @uses EtlRunSummary::setStatusText()
     * @uses EtlRunSummary::setTotalDurationMs()
     * @param string $completionCode
     * @param string $errorText
     * @param int $extractDurationMs
     * @param int $extractedRowCount
     * @param bool $isRunning
     * @param int $loadDurationMs
     * @param int $localId
     * @param string $runEndDateTimeUtc
     * @param string $runKind
     * @param string $runKindText
     * @param string $runStartDateTimeUtc
     * @param string $statusText
     * @param int $totalDurationMs
     */
    public function __construct($completionCode = null, $errorText = null, $extractDurationMs = null, $extractedRowCount = null, $isRunning = null, $loadDurationMs = null, $localId = null, $runEndDateTimeUtc = null, $runKind = null, $runKindText = null, $runStartDateTimeUtc = null, $statusText = null, $totalDurationMs = null)
    {
        $this
            ->setCompletionCode($completionCode)
            ->setErrorText($errorText)
            ->setExtractDurationMs($extractDurationMs)
            ->setExtractedRowCount($extractedRowCount)
            ->setIsRunning($isRunning)
            ->setLoadDurationMs($loadDurationMs)
            ->setLocalId($localId)
            ->setRunEndDateTimeUtc($runEndDateTimeUtc)
            ->setRunKind($runKind)
            ->setRunKindText($runKindText)
            ->setRunStartDateTimeUtc($runStartDateTimeUtc)
            ->setStatusText($statusText)
            ->setTotalDurationMs($totalDurationMs);
    }
    /**
     * Get CompletionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionCode()
    {
        return isset($this->CompletionCode) ? $this->CompletionCode : null;
    }
    /**
     * Set CompletionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completionCode
     * @return \patest\StructType\EtlRunSummary
     */
    public function setCompletionCode($completionCode = null)
    {
        // validation for constraint: string
        if (!is_null($completionCode) && !is_string($completionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionCode, true), gettype($completionCode)), __LINE__);
        }
        if (is_null($completionCode) || (is_array($completionCode) && empty($completionCode))) {
            unset($this->CompletionCode);
        } else {
            $this->CompletionCode = $completionCode;
        }
        return $this;
    }
    /**
     * Get ErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->ErrorText) ? $this->ErrorText : null;
    }
    /**
     * Set ErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \patest\StructType\EtlRunSummary
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->ErrorText);
        } else {
            $this->ErrorText = $errorText;
        }
        return $this;
    }
    /**
     * Get ExtractDurationMs value
     * @return int|null
     */
    public function getExtractDurationMs()
    {
        return $this->ExtractDurationMs;
    }
    /**
     * Set ExtractDurationMs value
     * @param int $extractDurationMs
     * @return \patest\StructType\EtlRunSummary
     */
    public function setExtractDurationMs($extractDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($extractDurationMs) && !(is_int($extractDurationMs) || ctype_digit($extractDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extractDurationMs, true), gettype($extractDurationMs)), __LINE__);
        }
        $this->ExtractDurationMs = $extractDurationMs;
        return $this;
    }
    /**
     * Get ExtractedRowCount value
     * @return int|null
     */
    public function getExtractedRowCount()
    {
        return $this->ExtractedRowCount;
    }
    /**
     * Set ExtractedRowCount value
     * @param int $extractedRowCount
     * @return \patest\StructType\EtlRunSummary
     */
    public function setExtractedRowCount($extractedRowCount = null)
    {
        // validation for constraint: int
        if (!is_null($extractedRowCount) && !(is_int($extractedRowCount) || ctype_digit($extractedRowCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extractedRowCount, true), gettype($extractedRowCount)), __LINE__);
        }
        $this->ExtractedRowCount = $extractedRowCount;
        return $this;
    }
    /**
     * Get IsRunning value
     * @return bool|null
     */
    public function getIsRunning()
    {
        return $this->IsRunning;
    }
    /**
     * Set IsRunning value
     * @param bool $isRunning
     * @return \patest\StructType\EtlRunSummary
     */
    public function setIsRunning($isRunning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRunning) && !is_bool($isRunning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRunning, true), gettype($isRunning)), __LINE__);
        }
        $this->IsRunning = $isRunning;
        return $this;
    }
    /**
     * Get LoadDurationMs value
     * @return int|null
     */
    public function getLoadDurationMs()
    {
        return $this->LoadDurationMs;
    }
    /**
     * Set LoadDurationMs value
     * @param int $loadDurationMs
     * @return \patest\StructType\EtlRunSummary
     */
    public function setLoadDurationMs($loadDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($loadDurationMs) && !(is_int($loadDurationMs) || ctype_digit($loadDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loadDurationMs, true), gettype($loadDurationMs)), __LINE__);
        }
        $this->LoadDurationMs = $loadDurationMs;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\EtlRunSummary
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get RunEndDateTimeUtc value
     * @return string|null
     */
    public function getRunEndDateTimeUtc()
    {
        return $this->RunEndDateTimeUtc;
    }
    /**
     * Set RunEndDateTimeUtc value
     * @param string $runEndDateTimeUtc
     * @return \patest\StructType\EtlRunSummary
     */
    public function setRunEndDateTimeUtc($runEndDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($runEndDateTimeUtc) && !is_string($runEndDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runEndDateTimeUtc, true), gettype($runEndDateTimeUtc)), __LINE__);
        }
        $this->RunEndDateTimeUtc = $runEndDateTimeUtc;
        return $this;
    }
    /**
     * Get RunKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunKind()
    {
        return isset($this->RunKind) ? $this->RunKind : null;
    }
    /**
     * Set RunKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runKind
     * @return \patest\StructType\EtlRunSummary
     */
    public function setRunKind($runKind = null)
    {
        // validation for constraint: string
        if (!is_null($runKind) && !is_string($runKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runKind, true), gettype($runKind)), __LINE__);
        }
        if (is_null($runKind) || (is_array($runKind) && empty($runKind))) {
            unset($this->RunKind);
        } else {
            $this->RunKind = $runKind;
        }
        return $this;
    }
    /**
     * Get RunKindText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunKindText()
    {
        return isset($this->RunKindText) ? $this->RunKindText : null;
    }
    /**
     * Set RunKindText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runKindText
     * @return \patest\StructType\EtlRunSummary
     */
    public function setRunKindText($runKindText = null)
    {
        // validation for constraint: string
        if (!is_null($runKindText) && !is_string($runKindText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runKindText, true), gettype($runKindText)), __LINE__);
        }
        if (is_null($runKindText) || (is_array($runKindText) && empty($runKindText))) {
            unset($this->RunKindText);
        } else {
            $this->RunKindText = $runKindText;
        }
        return $this;
    }
    /**
     * Get RunStartDateTimeUtc value
     * @return string|null
     */
    public function getRunStartDateTimeUtc()
    {
        return $this->RunStartDateTimeUtc;
    }
    /**
     * Set RunStartDateTimeUtc value
     * @param string $runStartDateTimeUtc
     * @return \patest\StructType\EtlRunSummary
     */
    public function setRunStartDateTimeUtc($runStartDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($runStartDateTimeUtc) && !is_string($runStartDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runStartDateTimeUtc, true), gettype($runStartDateTimeUtc)), __LINE__);
        }
        $this->RunStartDateTimeUtc = $runStartDateTimeUtc;
        return $this;
    }
    /**
     * Get StatusText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusText()
    {
        return isset($this->StatusText) ? $this->StatusText : null;
    }
    /**
     * Set StatusText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusText
     * @return \patest\StructType\EtlRunSummary
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusText, true), gettype($statusText)), __LINE__);
        }
        if (is_null($statusText) || (is_array($statusText) && empty($statusText))) {
            unset($this->StatusText);
        } else {
            $this->StatusText = $statusText;
        }
        return $this;
    }
    /**
     * Get TotalDurationMs value
     * @return int|null
     */
    public function getTotalDurationMs()
    {
        return $this->TotalDurationMs;
    }
    /**
     * Set TotalDurationMs value
     * @param int $totalDurationMs
     * @return \patest\StructType\EtlRunSummary
     */
    public function setTotalDurationMs($totalDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($totalDurationMs) && !(is_int($totalDurationMs) || ctype_digit($totalDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDurationMs, true), gettype($totalDurationMs)), __LINE__);
        }
        $this->TotalDurationMs = $totalDurationMs;
        return $this;
    }
}
