<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EtlProcessStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EtlProcessStatus
 * @subpackage Structs
 */
class EtlProcessStatus extends AbstractStructBase
{
    /**
     * The CurrentRunId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrentRunId;
    /**
     * The CurrentRunKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentRunKind;
    /**
     * The CurrentRunStartedAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrentRunStartedAtUtc;
    /**
     * The IsRunning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRunning;
    /**
     * The LastRunDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastRunDateTimeUtc;
    /**
     * The LastRunError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastRunError;
    /**
     * The LastRunId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LastRunId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The TimeSinceLastRunMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeSinceLastRunMinutes;
    /**
     * Constructor method for EtlProcessStatus
     * @uses EtlProcessStatus::setCurrentRunId()
     * @uses EtlProcessStatus::setCurrentRunKind()
     * @uses EtlProcessStatus::setCurrentRunStartedAtUtc()
     * @uses EtlProcessStatus::setIsRunning()
     * @uses EtlProcessStatus::setLastRunDateTimeUtc()
     * @uses EtlProcessStatus::setLastRunError()
     * @uses EtlProcessStatus::setLastRunId()
     * @uses EtlProcessStatus::setName()
     * @uses EtlProcessStatus::setTimeSinceLastRunMinutes()
     * @param int $currentRunId
     * @param string $currentRunKind
     * @param string $currentRunStartedAtUtc
     * @param bool $isRunning
     * @param string $lastRunDateTimeUtc
     * @param string $lastRunError
     * @param int $lastRunId
     * @param string $name
     * @param int $timeSinceLastRunMinutes
     */
    public function __construct($currentRunId = null, $currentRunKind = null, $currentRunStartedAtUtc = null, $isRunning = null, $lastRunDateTimeUtc = null, $lastRunError = null, $lastRunId = null, $name = null, $timeSinceLastRunMinutes = null)
    {
        $this
            ->setCurrentRunId($currentRunId)
            ->setCurrentRunKind($currentRunKind)
            ->setCurrentRunStartedAtUtc($currentRunStartedAtUtc)
            ->setIsRunning($isRunning)
            ->setLastRunDateTimeUtc($lastRunDateTimeUtc)
            ->setLastRunError($lastRunError)
            ->setLastRunId($lastRunId)
            ->setName($name)
            ->setTimeSinceLastRunMinutes($timeSinceLastRunMinutes);
    }
    /**
     * Get CurrentRunId value
     * @return int|null
     */
    public function getCurrentRunId()
    {
        return $this->CurrentRunId;
    }
    /**
     * Set CurrentRunId value
     * @param int $currentRunId
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setCurrentRunId($currentRunId = null)
    {
        // validation for constraint: int
        if (!is_null($currentRunId) && !(is_int($currentRunId) || ctype_digit($currentRunId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentRunId, true), gettype($currentRunId)), __LINE__);
        }
        $this->CurrentRunId = $currentRunId;
        return $this;
    }
    /**
     * Get CurrentRunKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentRunKind()
    {
        return isset($this->CurrentRunKind) ? $this->CurrentRunKind : null;
    }
    /**
     * Set CurrentRunKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentRunKind
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setCurrentRunKind($currentRunKind = null)
    {
        // validation for constraint: string
        if (!is_null($currentRunKind) && !is_string($currentRunKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentRunKind, true), gettype($currentRunKind)), __LINE__);
        }
        if (is_null($currentRunKind) || (is_array($currentRunKind) && empty($currentRunKind))) {
            unset($this->CurrentRunKind);
        } else {
            $this->CurrentRunKind = $currentRunKind;
        }
        return $this;
    }
    /**
     * Get CurrentRunStartedAtUtc value
     * @return string|null
     */
    public function getCurrentRunStartedAtUtc()
    {
        return $this->CurrentRunStartedAtUtc;
    }
    /**
     * Set CurrentRunStartedAtUtc value
     * @param string $currentRunStartedAtUtc
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setCurrentRunStartedAtUtc($currentRunStartedAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($currentRunStartedAtUtc) && !is_string($currentRunStartedAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentRunStartedAtUtc, true), gettype($currentRunStartedAtUtc)), __LINE__);
        }
        $this->CurrentRunStartedAtUtc = $currentRunStartedAtUtc;
        return $this;
    }
    /**
     * Get IsRunning value
     * @return bool|null
     */
    public function getIsRunning()
    {
        return $this->IsRunning;
    }
    /**
     * Set IsRunning value
     * @param bool $isRunning
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setIsRunning($isRunning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRunning) && !is_bool($isRunning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRunning, true), gettype($isRunning)), __LINE__);
        }
        $this->IsRunning = $isRunning;
        return $this;
    }
    /**
     * Get LastRunDateTimeUtc value
     * @return string|null
     */
    public function getLastRunDateTimeUtc()
    {
        return $this->LastRunDateTimeUtc;
    }
    /**
     * Set LastRunDateTimeUtc value
     * @param string $lastRunDateTimeUtc
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setLastRunDateTimeUtc($lastRunDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastRunDateTimeUtc) && !is_string($lastRunDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRunDateTimeUtc, true), gettype($lastRunDateTimeUtc)), __LINE__);
        }
        $this->LastRunDateTimeUtc = $lastRunDateTimeUtc;
        return $this;
    }
    /**
     * Get LastRunError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastRunError()
    {
        return isset($this->LastRunError) ? $this->LastRunError : null;
    }
    /**
     * Set LastRunError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastRunError
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setLastRunError($lastRunError = null)
    {
        // validation for constraint: string
        if (!is_null($lastRunError) && !is_string($lastRunError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRunError, true), gettype($lastRunError)), __LINE__);
        }
        if (is_null($lastRunError) || (is_array($lastRunError) && empty($lastRunError))) {
            unset($this->LastRunError);
        } else {
            $this->LastRunError = $lastRunError;
        }
        return $this;
    }
    /**
     * Get LastRunId value
     * @return int|null
     */
    public function getLastRunId()
    {
        return $this->LastRunId;
    }
    /**
     * Set LastRunId value
     * @param int $lastRunId
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setLastRunId($lastRunId = null)
    {
        // validation for constraint: int
        if (!is_null($lastRunId) && !(is_int($lastRunId) || ctype_digit($lastRunId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastRunId, true), gettype($lastRunId)), __LINE__);
        }
        $this->LastRunId = $lastRunId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TimeSinceLastRunMinutes value
     * @return int|null
     */
    public function getTimeSinceLastRunMinutes()
    {
        return $this->TimeSinceLastRunMinutes;
    }
    /**
     * Set TimeSinceLastRunMinutes value
     * @param int $timeSinceLastRunMinutes
     * @return \patest\StructType\EtlProcessStatus
     */
    public function setTimeSinceLastRunMinutes($timeSinceLastRunMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($timeSinceLastRunMinutes) && !(is_int($timeSinceLastRunMinutes) || ctype_digit($timeSinceLastRunMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeSinceLastRunMinutes, true), gettype($timeSinceLastRunMinutes)), __LINE__);
        }
        $this->TimeSinceLastRunMinutes = $timeSinceLastRunMinutes;
        return $this;
    }
}
