<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityInstructions StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityInstructions
 * @subpackage Structs
 */
class EntityInstructions extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The PropertiesToSetNull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SetNullInstructions
     */
    public $PropertiesToSetNull;
    /**
     * Constructor method for EntityInstructions
     * @uses EntityInstructions::setAction()
     * @uses EntityInstructions::setPropertiesToSetNull()
     * @param string $action
     * @param \patest\StructType\SetNullInstructions $propertiesToSetNull
     */
    public function __construct($action = null, \patest\StructType\SetNullInstructions $propertiesToSetNull = null)
    {
        $this
            ->setAction($action)
            ->setPropertiesToSetNull($propertiesToSetNull);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAction::valueIsValid()
     * @uses \patest\EnumType\EntityAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\EntityInstructions
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EntityAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\EntityAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get PropertiesToSetNull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SetNullInstructions|null
     */
    public function getPropertiesToSetNull()
    {
        return isset($this->PropertiesToSetNull) ? $this->PropertiesToSetNull : null;
    }
    /**
     * Set PropertiesToSetNull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SetNullInstructions $propertiesToSetNull
     * @return \patest\StructType\EntityInstructions
     */
    public function setPropertiesToSetNull(\patest\StructType\SetNullInstructions $propertiesToSetNull = null)
    {
        if (is_null($propertiesToSetNull) || (is_array($propertiesToSetNull) && empty($propertiesToSetNull))) {
            unset($this->PropertiesToSetNull);
        } else {
            $this->PropertiesToSetNull = $propertiesToSetNull;
        }
        return $this;
    }
}
