<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitiesInitRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntitiesInitRequest
 * @subpackage Structs
 */
class EntitiesInitRequest extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AnyEntity
     */
    public $EntityType;
    /**
     * Constructor method for EntitiesInitRequest
     * @uses EntitiesInitRequest::setEntityName()
     * @uses EntitiesInitRequest::setEntityType()
     * @param string $entityName
     * @param \patest\StructType\AnyEntity $entityType
     */
    public function __construct($entityName = null, \patest\StructType\AnyEntity $entityType = null)
    {
        $this
            ->setEntityName($entityName)
            ->setEntityType($entityType);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\EntitiesInitRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AnyEntity|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AnyEntity $entityType
     * @return \patest\StructType\EntitiesInitRequest
     */
    public function setEntityType(\patest\StructType\AnyEntity $entityType = null)
    {
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
}
