<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.DeliveryAddress StructType
 * @subpackage Structs
 */
class ESRO_DeliveryAddress extends AnyEntity
{
    /**
     * The AddressDetailId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressDetailId;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The DeliveryAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryAddress2;
    /**
     * The DeliveryAddress3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryAddress3;
    /**
     * The DeliveryCity
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryCity;
    /**
     * The DeliveryCityIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryCityIdOrName;
    /**
     * The DeliveryCountry
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryCountry;
    /**
     * The DeliveryCountryIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryCountryIdOrName;
    /**
     * The DeliveryRegion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryRegion;
    /**
     * The DeliveryState
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryState;
    /**
     * The DeliveryStateIdOrName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryStateIdOrName;
    /**
     * The DeliveryZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryZipCode;
    /**
     * The UseBillingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseBillingAddress;
    /**
     * Constructor method for eSRO.DeliveryAddress
     * @uses ESRO_DeliveryAddress::setAddressDetailId()
     * @uses ESRO_DeliveryAddress::setDeliveryAddress()
     * @uses ESRO_DeliveryAddress::setDeliveryAddress2()
     * @uses ESRO_DeliveryAddress::setDeliveryAddress3()
     * @uses ESRO_DeliveryAddress::setDeliveryCity()
     * @uses ESRO_DeliveryAddress::setDeliveryCityIdOrName()
     * @uses ESRO_DeliveryAddress::setDeliveryCountry()
     * @uses ESRO_DeliveryAddress::setDeliveryCountryIdOrName()
     * @uses ESRO_DeliveryAddress::setDeliveryRegion()
     * @uses ESRO_DeliveryAddress::setDeliveryState()
     * @uses ESRO_DeliveryAddress::setDeliveryStateIdOrName()
     * @uses ESRO_DeliveryAddress::setDeliveryZipCode()
     * @uses ESRO_DeliveryAddress::setUseBillingAddress()
     * @param string $addressDetailId
     * @param string $deliveryAddress
     * @param string $deliveryAddress2
     * @param string $deliveryAddress3
     * @param string $deliveryCity
     * @param string $deliveryCityIdOrName
     * @param string $deliveryCountry
     * @param string $deliveryCountryIdOrName
     * @param string $deliveryRegion
     * @param string $deliveryState
     * @param string $deliveryStateIdOrName
     * @param string $deliveryZipCode
     * @param bool $useBillingAddress
     */
    public function __construct($addressDetailId = null, $deliveryAddress = null, $deliveryAddress2 = null, $deliveryAddress3 = null, $deliveryCity = null, $deliveryCityIdOrName = null, $deliveryCountry = null, $deliveryCountryIdOrName = null, $deliveryRegion = null, $deliveryState = null, $deliveryStateIdOrName = null, $deliveryZipCode = null, $useBillingAddress = null)
    {
        $this
            ->setAddressDetailId($addressDetailId)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryAddress2($deliveryAddress2)
            ->setDeliveryAddress3($deliveryAddress3)
            ->setDeliveryCity($deliveryCity)
            ->setDeliveryCityIdOrName($deliveryCityIdOrName)
            ->setDeliveryCountry($deliveryCountry)
            ->setDeliveryCountryIdOrName($deliveryCountryIdOrName)
            ->setDeliveryRegion($deliveryRegion)
            ->setDeliveryState($deliveryState)
            ->setDeliveryStateIdOrName($deliveryStateIdOrName)
            ->setDeliveryZipCode($deliveryZipCode)
            ->setUseBillingAddress($useBillingAddress);
    }
    /**
     * Get AddressDetailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressDetailId()
    {
        return isset($this->AddressDetailId) ? $this->AddressDetailId : null;
    }
    /**
     * Set AddressDetailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressDetailId
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setAddressDetailId($addressDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetailId) && !is_string($addressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDetailId, true), gettype($addressDetailId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addressDetailId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addressDetailId, true)), __LINE__);
        }
        if (is_null($addressDetailId) || (is_array($addressDetailId) && empty($addressDetailId))) {
            unset($this->AddressDetailId);
        } else {
            $this->AddressDetailId = $addressDetailId;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->DeliveryAddress) ? $this->DeliveryAddress : null;
    }
    /**
     * Set DeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddress
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->DeliveryAddress);
        } else {
            $this->DeliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddress2()
    {
        return isset($this->DeliveryAddress2) ? $this->DeliveryAddress2 : null;
    }
    /**
     * Set DeliveryAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddress2
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryAddress2($deliveryAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress2) && !is_string($deliveryAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress2, true), gettype($deliveryAddress2)), __LINE__);
        }
        if (is_null($deliveryAddress2) || (is_array($deliveryAddress2) && empty($deliveryAddress2))) {
            unset($this->DeliveryAddress2);
        } else {
            $this->DeliveryAddress2 = $deliveryAddress2;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddress3()
    {
        return isset($this->DeliveryAddress3) ? $this->DeliveryAddress3 : null;
    }
    /**
     * Set DeliveryAddress3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddress3
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryAddress3($deliveryAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress3) && !is_string($deliveryAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress3, true), gettype($deliveryAddress3)), __LINE__);
        }
        if (is_null($deliveryAddress3) || (is_array($deliveryAddress3) && empty($deliveryAddress3))) {
            unset($this->DeliveryAddress3);
        } else {
            $this->DeliveryAddress3 = $deliveryAddress3;
        }
        return $this;
    }
    /**
     * Get DeliveryCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryCity()
    {
        return isset($this->DeliveryCity) ? $this->DeliveryCity : null;
    }
    /**
     * Set DeliveryCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryCity
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryCity($deliveryCity = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCity) && !is_string($deliveryCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCity, true), gettype($deliveryCity)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryCity) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryCity, true)), __LINE__);
        }
        if (is_null($deliveryCity) || (is_array($deliveryCity) && empty($deliveryCity))) {
            unset($this->DeliveryCity);
        } else {
            $this->DeliveryCity = $deliveryCity;
        }
        return $this;
    }
    /**
     * Get DeliveryCityIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryCityIdOrName()
    {
        return isset($this->DeliveryCityIdOrName) ? $this->DeliveryCityIdOrName : null;
    }
    /**
     * Set DeliveryCityIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryCityIdOrName
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryCityIdOrName($deliveryCityIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCityIdOrName) && !is_string($deliveryCityIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCityIdOrName, true), gettype($deliveryCityIdOrName)), __LINE__);
        }
        if (is_null($deliveryCityIdOrName) || (is_array($deliveryCityIdOrName) && empty($deliveryCityIdOrName))) {
            unset($this->DeliveryCityIdOrName);
        } else {
            $this->DeliveryCityIdOrName = $deliveryCityIdOrName;
        }
        return $this;
    }
    /**
     * Get DeliveryCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryCountry()
    {
        return isset($this->DeliveryCountry) ? $this->DeliveryCountry : null;
    }
    /**
     * Set DeliveryCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryCountry
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryCountry($deliveryCountry = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCountry) && !is_string($deliveryCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCountry, true), gettype($deliveryCountry)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryCountry) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryCountry, true)), __LINE__);
        }
        if (is_null($deliveryCountry) || (is_array($deliveryCountry) && empty($deliveryCountry))) {
            unset($this->DeliveryCountry);
        } else {
            $this->DeliveryCountry = $deliveryCountry;
        }
        return $this;
    }
    /**
     * Get DeliveryCountryIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryCountryIdOrName()
    {
        return isset($this->DeliveryCountryIdOrName) ? $this->DeliveryCountryIdOrName : null;
    }
    /**
     * Set DeliveryCountryIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryCountryIdOrName
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryCountryIdOrName($deliveryCountryIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCountryIdOrName) && !is_string($deliveryCountryIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCountryIdOrName, true), gettype($deliveryCountryIdOrName)), __LINE__);
        }
        if (is_null($deliveryCountryIdOrName) || (is_array($deliveryCountryIdOrName) && empty($deliveryCountryIdOrName))) {
            unset($this->DeliveryCountryIdOrName);
        } else {
            $this->DeliveryCountryIdOrName = $deliveryCountryIdOrName;
        }
        return $this;
    }
    /**
     * Get DeliveryRegion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryRegion()
    {
        return isset($this->DeliveryRegion) ? $this->DeliveryRegion : null;
    }
    /**
     * Set DeliveryRegion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryRegion
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryRegion($deliveryRegion = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryRegion) && !is_string($deliveryRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryRegion, true), gettype($deliveryRegion)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryRegion) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryRegion, true)), __LINE__);
        }
        if (is_null($deliveryRegion) || (is_array($deliveryRegion) && empty($deliveryRegion))) {
            unset($this->DeliveryRegion);
        } else {
            $this->DeliveryRegion = $deliveryRegion;
        }
        return $this;
    }
    /**
     * Get DeliveryState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryState()
    {
        return isset($this->DeliveryState) ? $this->DeliveryState : null;
    }
    /**
     * Set DeliveryState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryState
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryState($deliveryState = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryState) && !is_string($deliveryState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryState, true), gettype($deliveryState)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryState) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryState, true)), __LINE__);
        }
        if (is_null($deliveryState) || (is_array($deliveryState) && empty($deliveryState))) {
            unset($this->DeliveryState);
        } else {
            $this->DeliveryState = $deliveryState;
        }
        return $this;
    }
    /**
     * Get DeliveryStateIdOrName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryStateIdOrName()
    {
        return isset($this->DeliveryStateIdOrName) ? $this->DeliveryStateIdOrName : null;
    }
    /**
     * Set DeliveryStateIdOrName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryStateIdOrName
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryStateIdOrName($deliveryStateIdOrName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStateIdOrName) && !is_string($deliveryStateIdOrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStateIdOrName, true), gettype($deliveryStateIdOrName)), __LINE__);
        }
        if (is_null($deliveryStateIdOrName) || (is_array($deliveryStateIdOrName) && empty($deliveryStateIdOrName))) {
            unset($this->DeliveryStateIdOrName);
        } else {
            $this->DeliveryStateIdOrName = $deliveryStateIdOrName;
        }
        return $this;
    }
    /**
     * Get DeliveryZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryZipCode()
    {
        return isset($this->DeliveryZipCode) ? $this->DeliveryZipCode : null;
    }
    /**
     * Set DeliveryZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryZipCode
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setDeliveryZipCode($deliveryZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryZipCode) && !is_string($deliveryZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryZipCode, true), gettype($deliveryZipCode)), __LINE__);
        }
        if (is_null($deliveryZipCode) || (is_array($deliveryZipCode) && empty($deliveryZipCode))) {
            unset($this->DeliveryZipCode);
        } else {
            $this->DeliveryZipCode = $deliveryZipCode;
        }
        return $this;
    }
    /**
     * Get UseBillingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseBillingAddress()
    {
        return isset($this->UseBillingAddress) ? $this->UseBillingAddress : null;
    }
    /**
     * Set UseBillingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useBillingAddress
     * @return \patest\StructType\ESRO_DeliveryAddress
     */
    public function setUseBillingAddress($useBillingAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBillingAddress) && !is_bool($useBillingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBillingAddress, true), gettype($useBillingAddress)), __LINE__);
        }
        if (is_null($useBillingAddress) || (is_array($useBillingAddress) && empty($useBillingAddress))) {
            unset($this->UseBillingAddress);
        } else {
            $this->UseBillingAddress = $useBillingAddress;
        }
        return $this;
    }
}
