<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.Basket.UnSignedTicketsGroup StructType
 * @subpackage Structs
 */
class ESRO_Basket_UnSignedTicketsGroup extends ESRO_Basket_TicketsGroupBase
{
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatNote;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * The TotalFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalFullPrice;
    /**
     * The TotalListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalListPrice;
    /**
     * The TotalPriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPriceToPay;
    /**
     * Constructor method for eSRO.Basket.UnSignedTicketsGroup
     * @uses ESRO_Basket_UnSignedTicketsGroup::setSeatName()
     * @uses ESRO_Basket_UnSignedTicketsGroup::setSeatNote()
     * @uses ESRO_Basket_UnSignedTicketsGroup::setTicketsCount()
     * @uses ESRO_Basket_UnSignedTicketsGroup::setTotalFullPrice()
     * @uses ESRO_Basket_UnSignedTicketsGroup::setTotalListPrice()
     * @uses ESRO_Basket_UnSignedTicketsGroup::setTotalPriceToPay()
     * @param string $seatName
     * @param string $seatNote
     * @param int $ticketsCount
     * @param \patest\StructType\Money $totalFullPrice
     * @param \patest\StructType\Money $totalListPrice
     * @param \patest\StructType\Money $totalPriceToPay
     */
    public function __construct($seatName = null, $seatNote = null, $ticketsCount = null, \patest\StructType\Money $totalFullPrice = null, \patest\StructType\Money $totalListPrice = null, \patest\StructType\Money $totalPriceToPay = null)
    {
        $this
            ->setSeatName($seatName)
            ->setSeatNote($seatNote)
            ->setTicketsCount($ticketsCount)
            ->setTotalFullPrice($totalFullPrice)
            ->setTotalListPrice($totalListPrice)
            ->setTotalPriceToPay($totalPriceToPay);
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatNote()
    {
        return isset($this->SeatNote) ? $this->SeatNote : null;
    }
    /**
     * Set SeatNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatNote
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setSeatNote($seatNote = null)
    {
        // validation for constraint: string
        if (!is_null($seatNote) && !is_string($seatNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNote, true), gettype($seatNote)), __LINE__);
        }
        if (is_null($seatNote) || (is_array($seatNote) && empty($seatNote))) {
            unset($this->SeatNote);
        } else {
            $this->SeatNote = $seatNote;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
    /**
     * Get TotalFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalFullPrice()
    {
        return isset($this->TotalFullPrice) ? $this->TotalFullPrice : null;
    }
    /**
     * Set TotalFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalFullPrice
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setTotalFullPrice(\patest\StructType\Money $totalFullPrice = null)
    {
        if (is_null($totalFullPrice) || (is_array($totalFullPrice) && empty($totalFullPrice))) {
            unset($this->TotalFullPrice);
        } else {
            $this->TotalFullPrice = $totalFullPrice;
        }
        return $this;
    }
    /**
     * Get TotalListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalListPrice()
    {
        return isset($this->TotalListPrice) ? $this->TotalListPrice : null;
    }
    /**
     * Set TotalListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalListPrice
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setTotalListPrice(\patest\StructType\Money $totalListPrice = null)
    {
        if (is_null($totalListPrice) || (is_array($totalListPrice) && empty($totalListPrice))) {
            unset($this->TotalListPrice);
        } else {
            $this->TotalListPrice = $totalListPrice;
        }
        return $this;
    }
    /**
     * Get TotalPriceToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPriceToPay()
    {
        return isset($this->TotalPriceToPay) ? $this->TotalPriceToPay : null;
    }
    /**
     * Set TotalPriceToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPriceToPay
     * @return \patest\StructType\ESRO_Basket_UnSignedTicketsGroup
     */
    public function setTotalPriceToPay(\patest\StructType\Money $totalPriceToPay = null)
    {
        if (is_null($totalPriceToPay) || (is_array($totalPriceToPay) && empty($totalPriceToPay))) {
            unset($this->TotalPriceToPay);
        } else {
            $this->TotalPriceToPay = $totalPriceToPay;
        }
        return $this;
    }
}
