<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.Basket.DonationItems StructType
 * @subpackage Structs
 */
class ESRO_Basket_DonationItems extends ESRO_Basket_AbstractProductItem
{
    /**
     * The Fund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fund;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Tribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tribute;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Value;
    /**
     * Constructor method for eSRO.Basket.DonationItems
     * @uses ESRO_Basket_DonationItems::setFund()
     * @uses ESRO_Basket_DonationItems::setItemId()
     * @uses ESRO_Basket_DonationItems::setName()
     * @uses ESRO_Basket_DonationItems::setTribute()
     * @uses ESRO_Basket_DonationItems::setValue()
     * @param string $fund
     * @param int $itemId
     * @param string $name
     * @param string $tribute
     * @param \patest\StructType\Money $value
     */
    public function __construct($fund = null, $itemId = null, $name = null, $tribute = null, \patest\StructType\Money $value = null)
    {
        $this
            ->setFund($fund)
            ->setItemId($itemId)
            ->setName($name)
            ->setTribute($tribute)
            ->setValue($value);
    }
    /**
     * Get Fund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFund()
    {
        return isset($this->Fund) ? $this->Fund : null;
    }
    /**
     * Set Fund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fund
     * @return \patest\StructType\ESRO_Basket_DonationItems
     */
    public function setFund($fund = null)
    {
        // validation for constraint: string
        if (!is_null($fund) && !is_string($fund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fund, true), gettype($fund)), __LINE__);
        }
        if (is_null($fund) || (is_array($fund) && empty($fund))) {
            unset($this->Fund);
        } else {
            $this->Fund = $fund;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\ESRO_Basket_DonationItems
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ESRO_Basket_DonationItems
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Tribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTribute()
    {
        return isset($this->Tribute) ? $this->Tribute : null;
    }
    /**
     * Set Tribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tribute
     * @return \patest\StructType\ESRO_Basket_DonationItems
     */
    public function setTribute($tribute = null)
    {
        // validation for constraint: string
        if (!is_null($tribute) && !is_string($tribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tribute, true), gettype($tribute)), __LINE__);
        }
        if (is_null($tribute) || (is_array($tribute) && empty($tribute))) {
            unset($this->Tribute);
        } else {
            $this->Tribute = $tribute;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $value
     * @return \patest\StructType\ESRO_Basket_DonationItems
     */
    public function setValue(\patest\StructType\Money $value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
