<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DuplicateContext-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DuplicateContext-Response
 * @subpackage Structs
 */
class DuplicateContext_Response extends ExtensibleDataContract
{
    /**
     * The ConnectionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ConnectionProperties
     */
    public $ConnectionProperties;
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * Constructor method for DuplicateContext-Response
     * @uses DuplicateContext_Response::setConnectionProperties()
     * @uses DuplicateContext_Response::setContextId()
     * @param \patest\StructType\ConnectionProperties $connectionProperties
     * @param string $contextId
     */
    public function __construct(\patest\StructType\ConnectionProperties $connectionProperties = null, $contextId = null)
    {
        $this
            ->setConnectionProperties($connectionProperties)
            ->setContextId($contextId);
    }
    /**
     * Get ConnectionProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ConnectionProperties|null
     */
    public function getConnectionProperties()
    {
        return isset($this->ConnectionProperties) ? $this->ConnectionProperties : null;
    }
    /**
     * Set ConnectionProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ConnectionProperties $connectionProperties
     * @return \patest\StructType\DuplicateContext_Response
     */
    public function setConnectionProperties(\patest\StructType\ConnectionProperties $connectionProperties = null)
    {
        if (is_null($connectionProperties) || (is_array($connectionProperties) && empty($connectionProperties))) {
            unset($this->ConnectionProperties);
        } else {
            $this->ConnectionProperties = $connectionProperties;
        }
        return $this;
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\DuplicateContext_Response
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
}
