<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.UIFundExtended StructType
 * @subpackage Structs
 */
class Donation_UIFundExtended extends Donation_Fund
{
    /**
     * The ListOfGivingOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListOfGivingOptions;
    /**
     * The ListOfGivingOptionsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListOfGivingOptionsIds;
    /**
     * Constructor method for Donation.UIFundExtended
     * @uses Donation_UIFundExtended::setListOfGivingOptions()
     * @uses Donation_UIFundExtended::setListOfGivingOptionsIds()
     * @param string $listOfGivingOptions
     * @param string $listOfGivingOptionsIds
     */
    public function __construct($listOfGivingOptions = null, $listOfGivingOptionsIds = null)
    {
        $this
            ->setListOfGivingOptions($listOfGivingOptions)
            ->setListOfGivingOptionsIds($listOfGivingOptionsIds);
    }
    /**
     * Get ListOfGivingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListOfGivingOptions()
    {
        return isset($this->ListOfGivingOptions) ? $this->ListOfGivingOptions : null;
    }
    /**
     * Set ListOfGivingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listOfGivingOptions
     * @return \patest\StructType\Donation_UIFundExtended
     */
    public function setListOfGivingOptions($listOfGivingOptions = null)
    {
        // validation for constraint: string
        if (!is_null($listOfGivingOptions) && !is_string($listOfGivingOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listOfGivingOptions, true), gettype($listOfGivingOptions)), __LINE__);
        }
        if (is_null($listOfGivingOptions) || (is_array($listOfGivingOptions) && empty($listOfGivingOptions))) {
            unset($this->ListOfGivingOptions);
        } else {
            $this->ListOfGivingOptions = $listOfGivingOptions;
        }
        return $this;
    }
    /**
     * Get ListOfGivingOptionsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListOfGivingOptionsIds()
    {
        return isset($this->ListOfGivingOptionsIds) ? $this->ListOfGivingOptionsIds : null;
    }
    /**
     * Set ListOfGivingOptionsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listOfGivingOptionsIds
     * @return \patest\StructType\Donation_UIFundExtended
     */
    public function setListOfGivingOptionsIds($listOfGivingOptionsIds = null)
    {
        // validation for constraint: string
        if (!is_null($listOfGivingOptionsIds) && !is_string($listOfGivingOptionsIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listOfGivingOptionsIds, true), gettype($listOfGivingOptionsIds)), __LINE__);
        }
        if (is_null($listOfGivingOptionsIds) || (is_array($listOfGivingOptionsIds) && empty($listOfGivingOptionsIds))) {
            unset($this->ListOfGivingOptionsIds);
        } else {
            $this->ListOfGivingOptionsIds = $listOfGivingOptionsIds;
        }
        return $this;
    }
}
