<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.SalesFundFilter StructType
 * @subpackage Structs
 */
class Donation_SalesFundFilter extends FilterEntity
{
    /**
     * The BelongsToFundGroups
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BelongsToFundGroups;
    /**
     * The DefaultAppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAppealId;
    /**
     * The DefaultCampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultCampaignId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Donation.SalesFundFilter
     * @uses Donation_SalesFundFilter::setBelongsToFundGroups()
     * @uses Donation_SalesFundFilter::setDefaultAppealId()
     * @uses Donation_SalesFundFilter::setDefaultCampaignId()
     * @uses Donation_SalesFundFilter::setDescription()
     * @uses Donation_SalesFundFilter::setName()
     * @param string $belongsToFundGroups
     * @param string $defaultAppealId
     * @param string $defaultCampaignId
     * @param string $description
     * @param string $name
     */
    public function __construct($belongsToFundGroups = null, $defaultAppealId = null, $defaultCampaignId = null, $description = null, $name = null)
    {
        $this
            ->setBelongsToFundGroups($belongsToFundGroups)
            ->setDefaultAppealId($defaultAppealId)
            ->setDefaultCampaignId($defaultCampaignId)
            ->setDescription($description)
            ->setName($name);
    }
    /**
     * Get BelongsToFundGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBelongsToFundGroups()
    {
        return isset($this->BelongsToFundGroups) ? $this->BelongsToFundGroups : null;
    }
    /**
     * Set BelongsToFundGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $belongsToFundGroups
     * @return \patest\StructType\Donation_SalesFundFilter
     */
    public function setBelongsToFundGroups($belongsToFundGroups = null)
    {
        // validation for constraint: string
        if (!is_null($belongsToFundGroups) && !is_string($belongsToFundGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($belongsToFundGroups, true), gettype($belongsToFundGroups)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($belongsToFundGroups) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $belongsToFundGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($belongsToFundGroups, true)), __LINE__);
        }
        if (is_null($belongsToFundGroups) || (is_array($belongsToFundGroups) && empty($belongsToFundGroups))) {
            unset($this->BelongsToFundGroups);
        } else {
            $this->BelongsToFundGroups = $belongsToFundGroups;
        }
        return $this;
    }
    /**
     * Get DefaultAppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAppealId()
    {
        return isset($this->DefaultAppealId) ? $this->DefaultAppealId : null;
    }
    /**
     * Set DefaultAppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAppealId
     * @return \patest\StructType\Donation_SalesFundFilter
     */
    public function setDefaultAppealId($defaultAppealId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAppealId) && !is_string($defaultAppealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAppealId, true), gettype($defaultAppealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAppealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAppealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAppealId, true)), __LINE__);
        }
        if (is_null($defaultAppealId) || (is_array($defaultAppealId) && empty($defaultAppealId))) {
            unset($this->DefaultAppealId);
        } else {
            $this->DefaultAppealId = $defaultAppealId;
        }
        return $this;
    }
    /**
     * Get DefaultCampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCampaignId()
    {
        return isset($this->DefaultCampaignId) ? $this->DefaultCampaignId : null;
    }
    /**
     * Set DefaultCampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCampaignId
     * @return \patest\StructType\Donation_SalesFundFilter
     */
    public function setDefaultCampaignId($defaultCampaignId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCampaignId) && !is_string($defaultCampaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCampaignId, true), gettype($defaultCampaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultCampaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultCampaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultCampaignId, true)), __LINE__);
        }
        if (is_null($defaultCampaignId) || (is_array($defaultCampaignId) && empty($defaultCampaignId))) {
            unset($this->DefaultCampaignId);
        } else {
            $this->DefaultCampaignId = $defaultCampaignId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Donation_SalesFundFilter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Donation_SalesFundFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
