<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.PledgeInstallmentFilter StructType
 * @subpackage Structs
 */
class Donation_PledgeInstallmentFilter extends FilterEntity
{
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardSuffix;
    /**
     * The DueDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDateFrom;
    /**
     * The DueDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDateTo;
    /**
     * The ExecutionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDateFrom;
    /**
     * The ExecutionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDateTo;
    /**
     * The ExpiryDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateFrom;
    /**
     * The ExpiryDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateTo;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatus;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The Paid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Paid;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for Donation.PledgeInstallmentFilter
     * @uses Donation_PledgeInstallmentFilter::setClientName()
     * @uses Donation_PledgeInstallmentFilter::setCreditCardSuffix()
     * @uses Donation_PledgeInstallmentFilter::setDueDateFrom()
     * @uses Donation_PledgeInstallmentFilter::setDueDateTo()
     * @uses Donation_PledgeInstallmentFilter::setExecutionDateFrom()
     * @uses Donation_PledgeInstallmentFilter::setExecutionDateTo()
     * @uses Donation_PledgeInstallmentFilter::setExpiryDateFrom()
     * @uses Donation_PledgeInstallmentFilter::setExpiryDateTo()
     * @uses Donation_PledgeInstallmentFilter::setFundId()
     * @uses Donation_PledgeInstallmentFilter::setInstallmentPaymentMethodId()
     * @uses Donation_PledgeInstallmentFilter::setInstallmentStatus()
     * @uses Donation_PledgeInstallmentFilter::setMandateNumber()
     * @uses Donation_PledgeInstallmentFilter::setMandateTypeId()
     * @uses Donation_PledgeInstallmentFilter::setPaid()
     * @uses Donation_PledgeInstallmentFilter::setPaymentStatus()
     * @uses Donation_PledgeInstallmentFilter::setTransactionNumber()
     * @param string $clientName
     * @param string $creditCardSuffix
     * @param string $dueDateFrom
     * @param string $dueDateTo
     * @param string $executionDateFrom
     * @param string $executionDateTo
     * @param string $expiryDateFrom
     * @param string $expiryDateTo
     * @param string $fundId
     * @param string $installmentPaymentMethodId
     * @param string $installmentStatus
     * @param int $mandateNumber
     * @param string $mandateTypeId
     * @param string $paid
     * @param string $paymentStatus
     * @param string $transactionNumber
     */
    public function __construct($clientName = null, $creditCardSuffix = null, $dueDateFrom = null, $dueDateTo = null, $executionDateFrom = null, $executionDateTo = null, $expiryDateFrom = null, $expiryDateTo = null, $fundId = null, $installmentPaymentMethodId = null, $installmentStatus = null, $mandateNumber = null, $mandateTypeId = null, $paid = null, $paymentStatus = null, $transactionNumber = null)
    {
        $this
            ->setClientName($clientName)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setDueDateFrom($dueDateFrom)
            ->setDueDateTo($dueDateTo)
            ->setExecutionDateFrom($executionDateFrom)
            ->setExecutionDateTo($executionDateTo)
            ->setExpiryDateFrom($expiryDateFrom)
            ->setExpiryDateTo($expiryDateTo)
            ->setFundId($fundId)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentStatus($installmentStatus)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeId($mandateTypeId)
            ->setPaid($paid)
            ->setPaymentStatus($paymentStatus)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardSuffix
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setCreditCardSuffix($creditCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardSuffix) && !is_string($creditCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardSuffix, true), gettype($creditCardSuffix)), __LINE__);
        }
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get DueDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDateFrom()
    {
        return isset($this->DueDateFrom) ? $this->DueDateFrom : null;
    }
    /**
     * Set DueDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDateFrom
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setDueDateFrom($dueDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dueDateFrom) && !is_string($dueDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDateFrom, true), gettype($dueDateFrom)), __LINE__);
        }
        if (is_null($dueDateFrom) || (is_array($dueDateFrom) && empty($dueDateFrom))) {
            unset($this->DueDateFrom);
        } else {
            $this->DueDateFrom = $dueDateFrom;
        }
        return $this;
    }
    /**
     * Get DueDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDateTo()
    {
        return isset($this->DueDateTo) ? $this->DueDateTo : null;
    }
    /**
     * Set DueDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDateTo
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setDueDateTo($dueDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dueDateTo) && !is_string($dueDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDateTo, true), gettype($dueDateTo)), __LINE__);
        }
        if (is_null($dueDateTo) || (is_array($dueDateTo) && empty($dueDateTo))) {
            unset($this->DueDateTo);
        } else {
            $this->DueDateTo = $dueDateTo;
        }
        return $this;
    }
    /**
     * Get ExecutionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDateFrom()
    {
        return isset($this->ExecutionDateFrom) ? $this->ExecutionDateFrom : null;
    }
    /**
     * Set ExecutionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDateFrom
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setExecutionDateFrom($executionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($executionDateFrom) && !is_string($executionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDateFrom, true), gettype($executionDateFrom)), __LINE__);
        }
        if (is_null($executionDateFrom) || (is_array($executionDateFrom) && empty($executionDateFrom))) {
            unset($this->ExecutionDateFrom);
        } else {
            $this->ExecutionDateFrom = $executionDateFrom;
        }
        return $this;
    }
    /**
     * Get ExecutionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDateTo()
    {
        return isset($this->ExecutionDateTo) ? $this->ExecutionDateTo : null;
    }
    /**
     * Set ExecutionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDateTo
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setExecutionDateTo($executionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($executionDateTo) && !is_string($executionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDateTo, true), gettype($executionDateTo)), __LINE__);
        }
        if (is_null($executionDateTo) || (is_array($executionDateTo) && empty($executionDateTo))) {
            unset($this->ExecutionDateTo);
        } else {
            $this->ExecutionDateTo = $executionDateTo;
        }
        return $this;
    }
    /**
     * Get ExpiryDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateFrom()
    {
        return isset($this->ExpiryDateFrom) ? $this->ExpiryDateFrom : null;
    }
    /**
     * Set ExpiryDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateFrom
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setExpiryDateFrom($expiryDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateFrom) && !is_string($expiryDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateFrom, true), gettype($expiryDateFrom)), __LINE__);
        }
        if (is_null($expiryDateFrom) || (is_array($expiryDateFrom) && empty($expiryDateFrom))) {
            unset($this->ExpiryDateFrom);
        } else {
            $this->ExpiryDateFrom = $expiryDateFrom;
        }
        return $this;
    }
    /**
     * Get ExpiryDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateTo()
    {
        return isset($this->ExpiryDateTo) ? $this->ExpiryDateTo : null;
    }
    /**
     * Set ExpiryDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateTo
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setExpiryDateTo($expiryDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateTo) && !is_string($expiryDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateTo, true), gettype($expiryDateTo)), __LINE__);
        }
        if (is_null($expiryDateTo) || (is_array($expiryDateTo) && empty($expiryDateTo))) {
            unset($this->ExpiryDateTo);
        } else {
            $this->ExpiryDateTo = $expiryDateTo;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return isset($this->InstallmentPaymentMethodId) ? $this->InstallmentPaymentMethodId : null;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        if (is_null($installmentPaymentMethodId) || (is_array($installmentPaymentMethodId) && empty($installmentPaymentMethodId))) {
            unset($this->InstallmentPaymentMethodId);
        } else {
            $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get InstallmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatus()
    {
        return isset($this->InstallmentStatus) ? $this->InstallmentStatus : null;
    }
    /**
     * Set InstallmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentStatus::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentStatus
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setInstallmentStatus($installmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentStatus::valueIsValid($installmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentStatus', is_array($installmentStatus) ? implode(', ', $installmentStatus) : var_export($installmentStatus, true), implode(', ', \patest\EnumType\PledgeInstallmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($installmentStatus) || (is_array($installmentStatus) && empty($installmentStatus))) {
            unset($this->InstallmentStatus);
        } else {
            $this->InstallmentStatus = $installmentStatus;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get Paid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaid()
    {
        return isset($this->Paid) ? $this->Paid : null;
    }
    /**
     * Set Paid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaidState::valueIsValid()
     * @uses \patest\EnumType\PaidState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paid
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setPaid($paid = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaidState::valueIsValid($paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaidState', is_array($paid) ? implode(', ', $paid) : var_export($paid, true), implode(', ', \patest\EnumType\PaidState::getValidValues())), __LINE__);
        }
        if (is_null($paid) || (is_array($paid) && empty($paid))) {
            unset($this->Paid);
        } else {
            $this->Paid = $paid;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNumber
     * @return \patest\StructType\Donation_PledgeInstallmentFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
