<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.PledgeExtended StructType
 * @subpackage Structs
 */
class Donation_PledgeExtended extends Donation_Pledge
{
    /**
     * The AllPaid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllPaid;
    /**
     * The CreditCardDisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardDisplayName;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The InstallmentPaymentMethodType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentPaymentMethodType;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MandateTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateTypeName;
    /**
     * The NextDueDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextDueDate;
    /**
     * The PaidInstallments
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaidInstallments;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * Constructor method for Donation.PledgeExtended
     * @uses Donation_PledgeExtended::setAllPaid()
     * @uses Donation_PledgeExtended::setCreditCardDisplayName()
     * @uses Donation_PledgeExtended::setExpiryDate()
     * @uses Donation_PledgeExtended::setInstallmentPaymentMethodType()
     * @uses Donation_PledgeExtended::setMandateNumber()
     * @uses Donation_PledgeExtended::setMandateTypeName()
     * @uses Donation_PledgeExtended::setNextDueDate()
     * @uses Donation_PledgeExtended::setPaidInstallments()
     * @uses Donation_PledgeExtended::setPaymentDetails()
     * @param bool $allPaid
     * @param string $creditCardDisplayName
     * @param string $expiryDate
     * @param string $installmentPaymentMethodType
     * @param int $mandateNumber
     * @param string $mandateTypeName
     * @param string $nextDueDate
     * @param int $paidInstallments
     * @param string $paymentDetails
     */
    public function __construct($allPaid = null, $creditCardDisplayName = null, $expiryDate = null, $installmentPaymentMethodType = null, $mandateNumber = null, $mandateTypeName = null, $nextDueDate = null, $paidInstallments = null, $paymentDetails = null)
    {
        $this
            ->setAllPaid($allPaid)
            ->setCreditCardDisplayName($creditCardDisplayName)
            ->setExpiryDate($expiryDate)
            ->setInstallmentPaymentMethodType($installmentPaymentMethodType)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeName($mandateTypeName)
            ->setNextDueDate($nextDueDate)
            ->setPaidInstallments($paidInstallments)
            ->setPaymentDetails($paymentDetails);
    }
    /**
     * Get AllPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllPaid()
    {
        return isset($this->AllPaid) ? $this->AllPaid : null;
    }
    /**
     * Set AllPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allPaid
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setAllPaid($allPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($allPaid) && !is_bool($allPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allPaid, true), gettype($allPaid)), __LINE__);
        }
        if (is_null($allPaid) || (is_array($allPaid) && empty($allPaid))) {
            unset($this->AllPaid);
        } else {
            $this->AllPaid = $allPaid;
        }
        return $this;
    }
    /**
     * Get CreditCardDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardDisplayName()
    {
        return isset($this->CreditCardDisplayName) ? $this->CreditCardDisplayName : null;
    }
    /**
     * Set CreditCardDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardDisplayName
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setCreditCardDisplayName($creditCardDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardDisplayName) && !is_string($creditCardDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardDisplayName, true), gettype($creditCardDisplayName)), __LINE__);
        }
        if (is_null($creditCardDisplayName) || (is_array($creditCardDisplayName) && empty($creditCardDisplayName))) {
            unset($this->CreditCardDisplayName);
        } else {
            $this->CreditCardDisplayName = $creditCardDisplayName;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodType()
    {
        return isset($this->InstallmentPaymentMethodType) ? $this->InstallmentPaymentMethodType : null;
    }
    /**
     * Set InstallmentPaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentPaymentMethodType
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setInstallmentPaymentMethodType($installmentPaymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($installmentPaymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($installmentPaymentMethodType) ? implode(', ', $installmentPaymentMethodType) : var_export($installmentPaymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($installmentPaymentMethodType) || (is_array($installmentPaymentMethodType) && empty($installmentPaymentMethodType))) {
            unset($this->InstallmentPaymentMethodType);
        } else {
            $this->InstallmentPaymentMethodType = $installmentPaymentMethodType;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeName()
    {
        return isset($this->MandateTypeName) ? $this->MandateTypeName : null;
    }
    /**
     * Set MandateTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeName
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setMandateTypeName($mandateTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeName) && !is_string($mandateTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeName, true), gettype($mandateTypeName)), __LINE__);
        }
        if (is_null($mandateTypeName) || (is_array($mandateTypeName) && empty($mandateTypeName))) {
            unset($this->MandateTypeName);
        } else {
            $this->MandateTypeName = $mandateTypeName;
        }
        return $this;
    }
    /**
     * Get NextDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextDueDate()
    {
        return isset($this->NextDueDate) ? $this->NextDueDate : null;
    }
    /**
     * Set NextDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextDueDate
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setNextDueDate($nextDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextDueDate) && !is_string($nextDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextDueDate, true), gettype($nextDueDate)), __LINE__);
        }
        if (is_null($nextDueDate) || (is_array($nextDueDate) && empty($nextDueDate))) {
            unset($this->NextDueDate);
        } else {
            $this->NextDueDate = $nextDueDate;
        }
        return $this;
    }
    /**
     * Get PaidInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaidInstallments()
    {
        return isset($this->PaidInstallments) ? $this->PaidInstallments : null;
    }
    /**
     * Set PaidInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paidInstallments
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setPaidInstallments($paidInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($paidInstallments) && !(is_int($paidInstallments) || ctype_digit($paidInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paidInstallments, true), gettype($paidInstallments)), __LINE__);
        }
        if (is_null($paidInstallments) || (is_array($paidInstallments) && empty($paidInstallments))) {
            unset($this->PaidInstallments);
        } else {
            $this->PaidInstallments = $paidInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Donation_PledgeExtended
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
}
