<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.MatchingGiftBatchUnit StructType
 * @subpackage Structs
 */
class Donation_MatchingGiftBatchUnit extends PersistableEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The BillingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingDate;
    /**
     * The LastPrintDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPrintDateTime;
    /**
     * The LastSentByEmailDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSentByEmailDateTime;
    /**
     * The LastSentByEmailTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSentByEmailTo;
    /**
     * The MatcherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatcherId;
    /**
     * The OriginalDonationDefinitionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalDonationDefinitionId;
    /**
     * The OriginalDonationProductItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalDonationProductItemId;
    /**
     * The OriginalDonationValue
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OriginalDonationValue;
    /**
     * The OriginalDonorId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalDonorId;
    /**
     * The OriginalTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTransactionGuid;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleId;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The WasBilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasBilled;
    /**
     * The WasCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasCancelled;
    /**
     * The WasPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasPaid;
    /**
     * Constructor method for Donation.MatchingGiftBatchUnit
     * @uses Donation_MatchingGiftBatchUnit::setBatchId()
     * @uses Donation_MatchingGiftBatchUnit::setBillingDate()
     * @uses Donation_MatchingGiftBatchUnit::setLastPrintDateTime()
     * @uses Donation_MatchingGiftBatchUnit::setLastSentByEmailDateTime()
     * @uses Donation_MatchingGiftBatchUnit::setLastSentByEmailTo()
     * @uses Donation_MatchingGiftBatchUnit::setMatcherId()
     * @uses Donation_MatchingGiftBatchUnit::setOriginalDonationDefinitionId()
     * @uses Donation_MatchingGiftBatchUnit::setOriginalDonationProductItemId()
     * @uses Donation_MatchingGiftBatchUnit::setOriginalDonationValue()
     * @uses Donation_MatchingGiftBatchUnit::setOriginalDonorId()
     * @uses Donation_MatchingGiftBatchUnit::setOriginalTransactionGuid()
     * @uses Donation_MatchingGiftBatchUnit::setRoleId()
     * @uses Donation_MatchingGiftBatchUnit::setValue()
     * @uses Donation_MatchingGiftBatchUnit::setWasBilled()
     * @uses Donation_MatchingGiftBatchUnit::setWasCancelled()
     * @uses Donation_MatchingGiftBatchUnit::setWasPaid()
     * @param string $batchId
     * @param string $billingDate
     * @param string $lastPrintDateTime
     * @param string $lastSentByEmailDateTime
     * @param string $lastSentByEmailTo
     * @param string $matcherId
     * @param string $originalDonationDefinitionId
     * @param string $originalDonationProductItemId
     * @param float $originalDonationValue
     * @param string $originalDonorId
     * @param string $originalTransactionGuid
     * @param string $roleId
     * @param float $value
     * @param bool $wasBilled
     * @param bool $wasCancelled
     * @param bool $wasPaid
     */
    public function __construct($batchId = null, $billingDate = null, $lastPrintDateTime = null, $lastSentByEmailDateTime = null, $lastSentByEmailTo = null, $matcherId = null, $originalDonationDefinitionId = null, $originalDonationProductItemId = null, $originalDonationValue = null, $originalDonorId = null, $originalTransactionGuid = null, $roleId = null, $value = null, $wasBilled = null, $wasCancelled = null, $wasPaid = null)
    {
        $this
            ->setBatchId($batchId)
            ->setBillingDate($billingDate)
            ->setLastPrintDateTime($lastPrintDateTime)
            ->setLastSentByEmailDateTime($lastSentByEmailDateTime)
            ->setLastSentByEmailTo($lastSentByEmailTo)
            ->setMatcherId($matcherId)
            ->setOriginalDonationDefinitionId($originalDonationDefinitionId)
            ->setOriginalDonationProductItemId($originalDonationProductItemId)
            ->setOriginalDonationValue($originalDonationValue)
            ->setOriginalDonorId($originalDonorId)
            ->setOriginalTransactionGuid($originalTransactionGuid)
            ->setRoleId($roleId)
            ->setValue($value)
            ->setWasBilled($wasBilled)
            ->setWasCancelled($wasCancelled)
            ->setWasPaid($wasPaid);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get BillingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingDate()
    {
        return isset($this->BillingDate) ? $this->BillingDate : null;
    }
    /**
     * Set BillingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingDate
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setBillingDate($billingDate = null)
    {
        // validation for constraint: string
        if (!is_null($billingDate) && !is_string($billingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDate, true), gettype($billingDate)), __LINE__);
        }
        if (is_null($billingDate) || (is_array($billingDate) && empty($billingDate))) {
            unset($this->BillingDate);
        } else {
            $this->BillingDate = $billingDate;
        }
        return $this;
    }
    /**
     * Get LastPrintDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPrintDateTime()
    {
        return isset($this->LastPrintDateTime) ? $this->LastPrintDateTime : null;
    }
    /**
     * Set LastPrintDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPrintDateTime
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setLastPrintDateTime($lastPrintDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastPrintDateTime) && !is_string($lastPrintDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPrintDateTime, true), gettype($lastPrintDateTime)), __LINE__);
        }
        if (is_null($lastPrintDateTime) || (is_array($lastPrintDateTime) && empty($lastPrintDateTime))) {
            unset($this->LastPrintDateTime);
        } else {
            $this->LastPrintDateTime = $lastPrintDateTime;
        }
        return $this;
    }
    /**
     * Get LastSentByEmailDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSentByEmailDateTime()
    {
        return isset($this->LastSentByEmailDateTime) ? $this->LastSentByEmailDateTime : null;
    }
    /**
     * Set LastSentByEmailDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSentByEmailDateTime
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setLastSentByEmailDateTime($lastSentByEmailDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastSentByEmailDateTime) && !is_string($lastSentByEmailDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSentByEmailDateTime, true), gettype($lastSentByEmailDateTime)), __LINE__);
        }
        if (is_null($lastSentByEmailDateTime) || (is_array($lastSentByEmailDateTime) && empty($lastSentByEmailDateTime))) {
            unset($this->LastSentByEmailDateTime);
        } else {
            $this->LastSentByEmailDateTime = $lastSentByEmailDateTime;
        }
        return $this;
    }
    /**
     * Get LastSentByEmailTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSentByEmailTo()
    {
        return isset($this->LastSentByEmailTo) ? $this->LastSentByEmailTo : null;
    }
    /**
     * Set LastSentByEmailTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSentByEmailTo
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setLastSentByEmailTo($lastSentByEmailTo = null)
    {
        // validation for constraint: string
        if (!is_null($lastSentByEmailTo) && !is_string($lastSentByEmailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSentByEmailTo, true), gettype($lastSentByEmailTo)), __LINE__);
        }
        if (is_null($lastSentByEmailTo) || (is_array($lastSentByEmailTo) && empty($lastSentByEmailTo))) {
            unset($this->LastSentByEmailTo);
        } else {
            $this->LastSentByEmailTo = $lastSentByEmailTo;
        }
        return $this;
    }
    /**
     * Get MatcherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatcherId()
    {
        return isset($this->MatcherId) ? $this->MatcherId : null;
    }
    /**
     * Set MatcherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matcherId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setMatcherId($matcherId = null)
    {
        // validation for constraint: string
        if (!is_null($matcherId) && !is_string($matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherId, true), gettype($matcherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matcherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matcherId, true)), __LINE__);
        }
        if (is_null($matcherId) || (is_array($matcherId) && empty($matcherId))) {
            unset($this->MatcherId);
        } else {
            $this->MatcherId = $matcherId;
        }
        return $this;
    }
    /**
     * Get OriginalDonationDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalDonationDefinitionId()
    {
        return isset($this->OriginalDonationDefinitionId) ? $this->OriginalDonationDefinitionId : null;
    }
    /**
     * Set OriginalDonationDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalDonationDefinitionId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setOriginalDonationDefinitionId($originalDonationDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonationDefinitionId) && !is_string($originalDonationDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonationDefinitionId, true), gettype($originalDonationDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalDonationDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalDonationDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalDonationDefinitionId, true)), __LINE__);
        }
        if (is_null($originalDonationDefinitionId) || (is_array($originalDonationDefinitionId) && empty($originalDonationDefinitionId))) {
            unset($this->OriginalDonationDefinitionId);
        } else {
            $this->OriginalDonationDefinitionId = $originalDonationDefinitionId;
        }
        return $this;
    }
    /**
     * Get OriginalDonationProductItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalDonationProductItemId()
    {
        return isset($this->OriginalDonationProductItemId) ? $this->OriginalDonationProductItemId : null;
    }
    /**
     * Set OriginalDonationProductItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalDonationProductItemId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setOriginalDonationProductItemId($originalDonationProductItemId = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonationProductItemId) && !is_string($originalDonationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonationProductItemId, true), gettype($originalDonationProductItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalDonationProductItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalDonationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalDonationProductItemId, true)), __LINE__);
        }
        if (is_null($originalDonationProductItemId) || (is_array($originalDonationProductItemId) && empty($originalDonationProductItemId))) {
            unset($this->OriginalDonationProductItemId);
        } else {
            $this->OriginalDonationProductItemId = $originalDonationProductItemId;
        }
        return $this;
    }
    /**
     * Get OriginalDonationValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOriginalDonationValue()
    {
        return isset($this->OriginalDonationValue) ? $this->OriginalDonationValue : null;
    }
    /**
     * Set OriginalDonationValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $originalDonationValue
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setOriginalDonationValue($originalDonationValue = null)
    {
        // validation for constraint: float
        if (!is_null($originalDonationValue) && !(is_float($originalDonationValue) || is_numeric($originalDonationValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalDonationValue, true), gettype($originalDonationValue)), __LINE__);
        }
        if (is_null($originalDonationValue) || (is_array($originalDonationValue) && empty($originalDonationValue))) {
            unset($this->OriginalDonationValue);
        } else {
            $this->OriginalDonationValue = $originalDonationValue;
        }
        return $this;
    }
    /**
     * Get OriginalDonorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalDonorId()
    {
        return isset($this->OriginalDonorId) ? $this->OriginalDonorId : null;
    }
    /**
     * Set OriginalDonorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalDonorId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setOriginalDonorId($originalDonorId = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonorId) && !is_string($originalDonorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonorId, true), gettype($originalDonorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalDonorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalDonorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalDonorId, true)), __LINE__);
        }
        if (is_null($originalDonorId) || (is_array($originalDonorId) && empty($originalDonorId))) {
            unset($this->OriginalDonorId);
        } else {
            $this->OriginalDonorId = $originalDonorId;
        }
        return $this;
    }
    /**
     * Get OriginalTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTransactionGuid()
    {
        return isset($this->OriginalTransactionGuid) ? $this->OriginalTransactionGuid : null;
    }
    /**
     * Set OriginalTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTransactionGuid
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setOriginalTransactionGuid($originalTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionGuid) && !is_string($originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionGuid, true), gettype($originalTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTransactionGuid, true)), __LINE__);
        }
        if (is_null($originalTransactionGuid) || (is_array($originalTransactionGuid) && empty($originalTransactionGuid))) {
            unset($this->OriginalTransactionGuid);
        } else {
            $this->OriginalTransactionGuid = $originalTransactionGuid;
        }
        return $this;
    }
    /**
     * Get RoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleId()
    {
        return isset($this->RoleId) ? $this->RoleId : null;
    }
    /**
     * Set RoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleId
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roleId, true)), __LINE__);
        }
        if (is_null($roleId) || (is_array($roleId) && empty($roleId))) {
            unset($this->RoleId);
        } else {
            $this->RoleId = $roleId;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get WasBilled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasBilled()
    {
        return isset($this->WasBilled) ? $this->WasBilled : null;
    }
    /**
     * Set WasBilled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasBilled
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setWasBilled($wasBilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasBilled) && !is_bool($wasBilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasBilled, true), gettype($wasBilled)), __LINE__);
        }
        if (is_null($wasBilled) || (is_array($wasBilled) && empty($wasBilled))) {
            unset($this->WasBilled);
        } else {
            $this->WasBilled = $wasBilled;
        }
        return $this;
    }
    /**
     * Get WasCancelled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasCancelled()
    {
        return isset($this->WasCancelled) ? $this->WasCancelled : null;
    }
    /**
     * Set WasCancelled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasCancelled
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setWasCancelled($wasCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasCancelled) && !is_bool($wasCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasCancelled, true), gettype($wasCancelled)), __LINE__);
        }
        if (is_null($wasCancelled) || (is_array($wasCancelled) && empty($wasCancelled))) {
            unset($this->WasCancelled);
        } else {
            $this->WasCancelled = $wasCancelled;
        }
        return $this;
    }
    /**
     * Get WasPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasPaid()
    {
        return isset($this->WasPaid) ? $this->WasPaid : null;
    }
    /**
     * Set WasPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasPaid
     * @return \patest\StructType\Donation_MatchingGiftBatchUnit
     */
    public function setWasPaid($wasPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasPaid) && !is_bool($wasPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasPaid, true), gettype($wasPaid)), __LINE__);
        }
        if (is_null($wasPaid) || (is_array($wasPaid) && empty($wasPaid))) {
            unset($this->WasPaid);
        } else {
            $this->WasPaid = $wasPaid;
        }
        return $this;
    }
}
