<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.DonationExtended StructType
 * @subpackage Structs
 */
class Donation_DonationExtended extends Donation_DonationProductItem
{
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The AllocatedBenefitsNum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedBenefitsNum;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The DonationName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DonationName;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FundName;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PledgedOn
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PledgedOn;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserName;
    /**
     * The TransactionLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionLocalId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UsedBenefitsNum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UsedBenefitsNum;
    /**
     * Constructor method for Donation.DonationExtended
     * @uses Donation_DonationExtended::setAgencyAccountId()
     * @uses Donation_DonationExtended::setAgencyName()
     * @uses Donation_DonationExtended::setAllocatedBenefitsNum()
     * @uses Donation_DonationExtended::setCommitDate()
     * @uses Donation_DonationExtended::setDonationName()
     * @uses Donation_DonationExtended::setExtraInfo()
     * @uses Donation_DonationExtended::setFundName()
     * @uses Donation_DonationExtended::setItemId()
     * @uses Donation_DonationExtended::setOwnerName()
     * @uses Donation_DonationExtended::setPledgedOn()
     * @uses Donation_DonationExtended::setPurchaserClientId()
     * @uses Donation_DonationExtended::setPurchaserName()
     * @uses Donation_DonationExtended::setTransactionLocalId()
     * @uses Donation_DonationExtended::setTransactionNumber()
     * @uses Donation_DonationExtended::setUsedBenefitsNum()
     * @param string $agencyAccountId
     * @param string $agencyName
     * @param int $allocatedBenefitsNum
     * @param string $commitDate
     * @param \patest\StructType\GlobalString $donationName
     * @param string $extraInfo
     * @param \patest\StructType\GlobalString $fundName
     * @param int $itemId
     * @param string $ownerName
     * @param string $pledgedOn
     * @param string $purchaserClientId
     * @param string $purchaserName
     * @param int $transactionLocalId
     * @param int $transactionNumber
     * @param int $usedBenefitsNum
     */
    public function __construct($agencyAccountId = null, $agencyName = null, $allocatedBenefitsNum = null, $commitDate = null, \patest\StructType\GlobalString $donationName = null, $extraInfo = null, \patest\StructType\GlobalString $fundName = null, $itemId = null, $ownerName = null, $pledgedOn = null, $purchaserClientId = null, $purchaserName = null, $transactionLocalId = null, $transactionNumber = null, $usedBenefitsNum = null)
    {
        $this
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyName($agencyName)
            ->setAllocatedBenefitsNum($allocatedBenefitsNum)
            ->setCommitDate($commitDate)
            ->setDonationName($donationName)
            ->setExtraInfo($extraInfo)
            ->setFundName($fundName)
            ->setItemId($itemId)
            ->setOwnerName($ownerName)
            ->setPledgedOn($pledgedOn)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserName($purchaserName)
            ->setTransactionLocalId($transactionLocalId)
            ->setTransactionNumber($transactionNumber)
            ->setUsedBenefitsNum($usedBenefitsNum);
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyName()
    {
        return isset($this->AgencyName) ? $this->AgencyName : null;
    }
    /**
     * Set AgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyName
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        if (is_null($agencyName) || (is_array($agencyName) && empty($agencyName))) {
            unset($this->AgencyName);
        } else {
            $this->AgencyName = $agencyName;
        }
        return $this;
    }
    /**
     * Get AllocatedBenefitsNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedBenefitsNum()
    {
        return isset($this->AllocatedBenefitsNum) ? $this->AllocatedBenefitsNum : null;
    }
    /**
     * Set AllocatedBenefitsNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedBenefitsNum
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setAllocatedBenefitsNum($allocatedBenefitsNum = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedBenefitsNum) && !(is_int($allocatedBenefitsNum) || ctype_digit($allocatedBenefitsNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedBenefitsNum, true), gettype($allocatedBenefitsNum)), __LINE__);
        }
        if (is_null($allocatedBenefitsNum) || (is_array($allocatedBenefitsNum) && empty($allocatedBenefitsNum))) {
            unset($this->AllocatedBenefitsNum);
        } else {
            $this->AllocatedBenefitsNum = $allocatedBenefitsNum;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get DonationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDonationName()
    {
        return isset($this->DonationName) ? $this->DonationName : null;
    }
    /**
     * Set DonationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $donationName
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setDonationName(\patest\StructType\GlobalString $donationName = null)
    {
        if (is_null($donationName) || (is_array($donationName) && empty($donationName))) {
            unset($this->DonationName);
        } else {
            $this->DonationName = $donationName;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fundName
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setFundName(\patest\StructType\GlobalString $fundName = null)
    {
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PledgedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgedOn()
    {
        return isset($this->PledgedOn) ? $this->PledgedOn : null;
    }
    /**
     * Set PledgedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgedOn
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setPledgedOn($pledgedOn = null)
    {
        // validation for constraint: string
        if (!is_null($pledgedOn) && !is_string($pledgedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgedOn, true), gettype($pledgedOn)), __LINE__);
        }
        if (is_null($pledgedOn) || (is_array($pledgedOn) && empty($pledgedOn))) {
            unset($this->PledgedOn);
        } else {
            $this->PledgedOn = $pledgedOn;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserName()
    {
        return isset($this->PurchaserName) ? $this->PurchaserName : null;
    }
    /**
     * Set PurchaserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserName
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setPurchaserName($purchaserName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserName) && !is_string($purchaserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserName, true), gettype($purchaserName)), __LINE__);
        }
        if (is_null($purchaserName) || (is_array($purchaserName) && empty($purchaserName))) {
            unset($this->PurchaserName);
        } else {
            $this->PurchaserName = $purchaserName;
        }
        return $this;
    }
    /**
     * Get TransactionLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionLocalId()
    {
        return isset($this->TransactionLocalId) ? $this->TransactionLocalId : null;
    }
    /**
     * Set TransactionLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionLocalId
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setTransactionLocalId($transactionLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionLocalId) && !(is_int($transactionLocalId) || ctype_digit($transactionLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionLocalId, true), gettype($transactionLocalId)), __LINE__);
        }
        if (is_null($transactionLocalId) || (is_array($transactionLocalId) && empty($transactionLocalId))) {
            unset($this->TransactionLocalId);
        } else {
            $this->TransactionLocalId = $transactionLocalId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UsedBenefitsNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUsedBenefitsNum()
    {
        return isset($this->UsedBenefitsNum) ? $this->UsedBenefitsNum : null;
    }
    /**
     * Set UsedBenefitsNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $usedBenefitsNum
     * @return \patest\StructType\Donation_DonationExtended
     */
    public function setUsedBenefitsNum($usedBenefitsNum = null)
    {
        // validation for constraint: int
        if (!is_null($usedBenefitsNum) && !(is_int($usedBenefitsNum) || ctype_digit($usedBenefitsNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usedBenefitsNum, true), gettype($usedBenefitsNum)), __LINE__);
        }
        if (is_null($usedBenefitsNum) || (is_array($usedBenefitsNum) && empty($usedBenefitsNum))) {
            unset($this->UsedBenefitsNum);
        } else {
            $this->UsedBenefitsNum = $usedBenefitsNum;
        }
        return $this;
    }
}
