<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisplayInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DisplayInfo
 * @subpackage Structs
 */
class DisplayInfo extends AbstractStructBase
{
    /**
     * The ExtraWhere
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraWhere;
    /**
     * The RetrievableObject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RetrievableObject;
    /**
     * Constructor method for DisplayInfo
     * @uses DisplayInfo::setExtraWhere()
     * @uses DisplayInfo::setRetrievableObject()
     * @param string $extraWhere
     * @param string $retrievableObject
     */
    public function __construct($extraWhere = null, $retrievableObject = null)
    {
        $this
            ->setExtraWhere($extraWhere)
            ->setRetrievableObject($retrievableObject);
    }
    /**
     * Get ExtraWhere value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraWhere()
    {
        return isset($this->ExtraWhere) ? $this->ExtraWhere : null;
    }
    /**
     * Set ExtraWhere value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraWhere
     * @return \patest\StructType\DisplayInfo
     */
    public function setExtraWhere($extraWhere = null)
    {
        // validation for constraint: string
        if (!is_null($extraWhere) && !is_string($extraWhere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraWhere, true), gettype($extraWhere)), __LINE__);
        }
        if (is_null($extraWhere) || (is_array($extraWhere) && empty($extraWhere))) {
            unset($this->ExtraWhere);
        } else {
            $this->ExtraWhere = $extraWhere;
        }
        return $this;
    }
    /**
     * Get RetrievableObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetrievableObject()
    {
        return isset($this->RetrievableObject) ? $this->RetrievableObject : null;
    }
    /**
     * Set RetrievableObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retrievableObject
     * @return \patest\StructType\DisplayInfo
     */
    public function setRetrievableObject($retrievableObject = null)
    {
        // validation for constraint: string
        if (!is_null($retrievableObject) && !is_string($retrievableObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievableObject, true), gettype($retrievableObject)), __LINE__);
        }
        if (is_null($retrievableObject) || (is_array($retrievableObject) && empty($retrievableObject))) {
            unset($this->RetrievableObject);
        } else {
            $this->RetrievableObject = $retrievableObject;
        }
        return $this;
    }
}
