<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectDebitDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DirectDebitDescription
 * @subpackage Structs
 */
class DirectDebitDescription extends AbstractPaymentDescription
{
    /**
     * The AutoDirectDebitClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AutoDirectDebitClientId;
    /**
     * The CollectPaymentOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectPaymentOnDate;
    /**
     * The DirectDebitMandate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_DirectDebitMandate
     */
    public $DirectDebitMandate;
    /**
     * The IsAutoDirectDebit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAutoDirectDebit;
    /**
     * The MandateOnlyForThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MandateOnlyForThisTransaction;
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The PayUsingPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUsingPaymentTokenId;
    /**
     * The IsForFuturePayInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayInternally;
    /**
     * Constructor method for DirectDebitDescription
     * @uses DirectDebitDescription::setAutoDirectDebitClientId()
     * @uses DirectDebitDescription::setCollectPaymentOnDate()
     * @uses DirectDebitDescription::setDirectDebitMandate()
     * @uses DirectDebitDescription::setIsAutoDirectDebit()
     * @uses DirectDebitDescription::setMandateOnlyForThisTransaction()
     * @uses DirectDebitDescription::setIsForFuturePayByCustomer()
     * @uses DirectDebitDescription::setPayUsingPaymentTokenId()
     * @uses DirectDebitDescription::setIsForFuturePayInternally()
     * @param string $autoDirectDebitClientId
     * @param string $collectPaymentOnDate
     * @param \patest\StructType\Payment_DirectDebitMandate $directDebitMandate
     * @param bool $isAutoDirectDebit
     * @param bool $mandateOnlyForThisTransaction
     * @param bool $isForFuturePayByCustomer
     * @param string $payUsingPaymentTokenId
     * @param bool $isForFuturePayInternally
     */
    public function __construct($autoDirectDebitClientId = null, $collectPaymentOnDate = null, \patest\StructType\Payment_DirectDebitMandate $directDebitMandate = null, $isAutoDirectDebit = null, $mandateOnlyForThisTransaction = null, $isForFuturePayByCustomer = null, $payUsingPaymentTokenId = null, $isForFuturePayInternally = null)
    {
        $this
            ->setAutoDirectDebitClientId($autoDirectDebitClientId)
            ->setCollectPaymentOnDate($collectPaymentOnDate)
            ->setDirectDebitMandate($directDebitMandate)
            ->setIsAutoDirectDebit($isAutoDirectDebit)
            ->setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction)
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setPayUsingPaymentTokenId($payUsingPaymentTokenId)
            ->setIsForFuturePayInternally($isForFuturePayInternally);
    }
    /**
     * Get AutoDirectDebitClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutoDirectDebitClientId()
    {
        return isset($this->AutoDirectDebitClientId) ? $this->AutoDirectDebitClientId : null;
    }
    /**
     * Set AutoDirectDebitClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $autoDirectDebitClientId
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setAutoDirectDebitClientId($autoDirectDebitClientId = null)
    {
        // validation for constraint: string
        if (!is_null($autoDirectDebitClientId) && !is_string($autoDirectDebitClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoDirectDebitClientId, true), gettype($autoDirectDebitClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($autoDirectDebitClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $autoDirectDebitClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($autoDirectDebitClientId, true)), __LINE__);
        }
        if (is_null($autoDirectDebitClientId) || (is_array($autoDirectDebitClientId) && empty($autoDirectDebitClientId))) {
            unset($this->AutoDirectDebitClientId);
        } else {
            $this->AutoDirectDebitClientId = $autoDirectDebitClientId;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectPaymentOnDate()
    {
        return isset($this->CollectPaymentOnDate) ? $this->CollectPaymentOnDate : null;
    }
    /**
     * Set CollectPaymentOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectPaymentOnDate
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setCollectPaymentOnDate($collectPaymentOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($collectPaymentOnDate) && !is_string($collectPaymentOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectPaymentOnDate, true), gettype($collectPaymentOnDate)), __LINE__);
        }
        if (is_null($collectPaymentOnDate) || (is_array($collectPaymentOnDate) && empty($collectPaymentOnDate))) {
            unset($this->CollectPaymentOnDate);
        } else {
            $this->CollectPaymentOnDate = $collectPaymentOnDate;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_DirectDebitMandate|null
     */
    public function getDirectDebitMandate()
    {
        return isset($this->DirectDebitMandate) ? $this->DirectDebitMandate : null;
    }
    /**
     * Set DirectDebitMandate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_DirectDebitMandate $directDebitMandate
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setDirectDebitMandate(\patest\StructType\Payment_DirectDebitMandate $directDebitMandate = null)
    {
        if (is_null($directDebitMandate) || (is_array($directDebitMandate) && empty($directDebitMandate))) {
            unset($this->DirectDebitMandate);
        } else {
            $this->DirectDebitMandate = $directDebitMandate;
        }
        return $this;
    }
    /**
     * Get IsAutoDirectDebit value
     * @return bool|null
     */
    public function getIsAutoDirectDebit()
    {
        return $this->IsAutoDirectDebit;
    }
    /**
     * Set IsAutoDirectDebit value
     * @param bool $isAutoDirectDebit
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setIsAutoDirectDebit($isAutoDirectDebit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoDirectDebit) && !is_bool($isAutoDirectDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoDirectDebit, true), gettype($isAutoDirectDebit)), __LINE__);
        }
        $this->IsAutoDirectDebit = $isAutoDirectDebit;
        return $this;
    }
    /**
     * Get MandateOnlyForThisTransaction value
     * @return bool|null
     */
    public function getMandateOnlyForThisTransaction()
    {
        return $this->MandateOnlyForThisTransaction;
    }
    /**
     * Set MandateOnlyForThisTransaction value
     * @param bool $mandateOnlyForThisTransaction
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateOnlyForThisTransaction) && !is_bool($mandateOnlyForThisTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateOnlyForThisTransaction, true), gettype($mandateOnlyForThisTransaction)), __LINE__);
        }
        $this->MandateOnlyForThisTransaction = $mandateOnlyForThisTransaction;
        return $this;
    }
    /**
     * Get IsForFuturePayByCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return isset($this->IsForFuturePayByCustomer) ? $this->IsForFuturePayByCustomer : null;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        if (is_null($isForFuturePayByCustomer) || (is_array($isForFuturePayByCustomer) && empty($isForFuturePayByCustomer))) {
            unset($this->IsForFuturePayByCustomer);
        } else {
            $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        }
        return $this;
    }
    /**
     * Get PayUsingPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUsingPaymentTokenId()
    {
        return isset($this->PayUsingPaymentTokenId) ? $this->PayUsingPaymentTokenId : null;
    }
    /**
     * Set PayUsingPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUsingPaymentTokenId
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setPayUsingPaymentTokenId($payUsingPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($payUsingPaymentTokenId) && !is_string($payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUsingPaymentTokenId, true), gettype($payUsingPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUsingPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUsingPaymentTokenId, true)), __LINE__);
        }
        if (is_null($payUsingPaymentTokenId) || (is_array($payUsingPaymentTokenId) && empty($payUsingPaymentTokenId))) {
            unset($this->PayUsingPaymentTokenId);
        } else {
            $this->PayUsingPaymentTokenId = $payUsingPaymentTokenId;
        }
        return $this;
    }
    /**
     * Get IsForFuturePayInternally value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayInternally()
    {
        return isset($this->IsForFuturePayInternally) ? $this->IsForFuturePayInternally : null;
    }
    /**
     * Set IsForFuturePayInternally value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayInternally
     * @return \patest\StructType\DirectDebitDescription
     */
    public function setIsForFuturePayInternally($isForFuturePayInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayInternally) && !is_bool($isForFuturePayInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayInternally, true), gettype($isForFuturePayInternally)), __LINE__);
        }
        if (is_null($isForFuturePayInternally) || (is_array($isForFuturePayInternally) && empty($isForFuturePayInternally))) {
            unset($this->IsForFuturePayInternally);
        } else {
            $this->IsForFuturePayInternally = $isForFuturePayInternally;
        }
        return $this;
    }
}
